# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).

## [5.12.2] - 2023-07-31
### Fixed
- Importing front-applet in TypeScript environment

## [5.12.1] - 2023-07-18
### Fixed
- Missing docs about new stream options on prepare and play functions
- Not returning promise on stream functions

## [5.12.0] - 2023-07-13
### Added
- `sos.sync.cancelWait()`
- `sos.sync.onClosed()`
- `sos.sync.connect()` accepts sync engine type `p2p-local` which replaces `udp`
- Options parameter on method `sos.stream.prepare()` for setting ex. background prepare
- Options parameters `autoReconnect` & `autoReconnectInterval` on prepare and play stream functions
- New file system method `sos.filesystem.createArchive()` to create a archive file

### Fixed
- Stream event listeners on play, prepare and stop functions
- Wrong return type on `sos.management.os.getMemoryUsage()`

### Deprecated
- Sync engine `udp` is replaced with `p2p-local`

## [5.11.1] - 2023-05-29
### Fixed
- Input issues on some platforms with keyUp listener

## [5.11.0] - 2023-05-15
### Added
- Methods to control and monitor Auto recovery process

### Fixed
- Peer recovery methods unified with Auto recovery
- `sos.sync.onStatus` won't be also called anytime broadcast value is received

## [5.10.2] - 2023-05-05
### Fixed
- Try delete proprietary timers with proper delete method (backward compatiblility is kept)

## [5.10.1] - 2023-04-26
### Fixed
- Validations of proprietary timer API (remove extra warning)

## [5.10.0] - 2023-04-06
### Added
- New Management API for `sos.management.power.setProprietaryTimer()`, `sos.management.power.unsetProprietaryTimer()`, `sos.management.power.getProprietaryTimers()`

## [5.9.0] - 2023-03-31
### Added
- `sos.sync.joinGroup()`
- `sos.sync.leaveGroup()`
- `sos.sync.broadcastValue()`
- `sos.sync.connect()` allows selection of which sync engine will be used for connection

### Deprecated
- `sos.sync.init()`
- `sos.sync.setValue()`

## [5.8.0] - 2023-03-16
### Added
- Method `sos.refresh()` has capability for relaunch applet
- Debug has new method `sos.debug.onRemoteDebugChanged()`, which accepts a function that is executed as a callback.
- Method `sos.debug.isRemoteDebugEnabled()` - information about REMOTE DEBUGGING setting

### Fixed
- Wrong return type on `sos.management.wifi.getConnectedTo()`

## [5.7.0] - 2023-02-16
### Added
- `device` key for opening serial port is not required now
- Proof of play initial implementation
- Update iframe documentation about a potential issue with zipping file using python
- Device Info Brand -> `sos.management.getBrand()`

## [5.6.0] - 2023-01-10
### Added
- Update serial port documentation

## [5.5.0] - 2022-10-24
### Added
- Method for opening OSD `sos.osd.showOSD()`

## [5.4.2] - 2022-08-30
### Fixed
- sos.input.onKeyUp did not work correctly on older devices

## [5.4.1] - 2022-07-25
### Fixed
- Webpack usage of main file of library.

## [5.4.0] - 2022-07-20
### Added
- CPU and Memory usage info
- Proxy management
- Wifi network ssid and signal strength information
- Possibility to enable Front-OSD while applet active
- Toggle Peer Recovery

## [5.3.1] - 2022-05-23
### Fixed
- Documentation for serial device name on supported platforms

## [5.3.0] - 2022-04-13
### Added
- Documentation for device info

## [5.2.0] - 2022-04-06
### Added
- Method onStatus in sos.sync - return connected devices in sync group
- Device info category: Methods to get location and organization tags
- Add new filesystem and offline cache methods into monitoring for SDK
- OS version info API (Windows 10 -> 10, WebOS 4 -> 4, etc)

## [5.1.1] - 2022-02-08
### Fixed
- Fixed applet basics links

## [5.1.0] - 2022-01-27
### Added
- Update firmware guide with new methods

### Fixed
- fix backlinks from old to new Docs

## [5.0.1] - 2022-01-25
### Fixed
- adjusted documentation to better reflect naming of JS SDK

## [5.0.0] - 2022-01-13
### Changed
- onceEnded promise on video will be rejected when video is stopped before it's end
- Video and Stream methods checks coordinations and warn when are in wrong format or throws error when are not castable to integer

## [4.15.0] - 2021-12-15
### Added
- Management Time setManual accepts an object with absolute datetime

### Fixed
- Updated documentation

## [4.14.0] - 2021-12-03
### Added
- Wi-Fi API connect to a hidden network

## [4.13.0] - 2021-11-26
### Added
- FS API appendFile
- Management Network API disableInterface

## [4.12.0] - 2021-10-04
### Added
- Headless Browser API

## [4.11.0] - 2021-09-28
### Added
- Listen for when the custom browser closes

### Fixed
- Fixed link to Firmware `getType()`
- Barcode scanner API

## [4.10.4] - 2021-04-14
### Fixed
- Added mising documentation for `sos.management.app.getType()`

## [4.10.3] - 2021-04-12
### Fixed
- Added mising documentation for `sos.display.supports()`
- Fixed warning in Serial API - suggest using `sos.display.supports()` instead of `sos.management.supports()`

## [4.10.2] - 2021-03-09
### Fixed
- Improved documentation of IR Remote control Input

## [4.10.1] - 2021-03-05
### Fixed
- Improved documentation of Applet Commands
- Better parameters description in video stream API documentation

## [4.10.0] - 2021-02-09
### Added
- New, improved versions of `sos.management.network.setManual()` and `sos.management.network.setDHCP()` which allow to specify an exact network interface in case there are multiple interfaces of the same type

## [4.9.1] - 2021-02-05
### Fixed
- Fix sos.management.network.listInterfaces() return type

## [4.9.0] - 2021-02-04
### Added
- Integrate Weinre debugging tool to applet iframe when appropriate message come from front-display
- sos.management.network.listInterfaces()

### Deprecated
- `sos.management.network.getActiveInfo()`

### Fixed
- Added files system example for creating multiple directories at once
- Added better explanation how to change orientation on Tizen

## [4.8.1] - 2021-01-18
### Fixed
- Missing documentation for sos.browser.close()
- Missing examples for applet commands

## [4.8.0] - 2021-01-14
### Added
- sos.management.firmware.getType method returns a string identifier, that, when combined with firmware version, can be used to identify a correct firmware image to install on the current device  

## [4.7.0] - 2021-01-08
### Added
- sos.management.screen.getOrientation method returns current orientation of the screen
- sos.stream.prepare method to prepare stream in the background ahead of playing it to allow gapless transitions similar to video

## [4.6.1] - 2021-01-04
### Fixed
- Missing documentation page about monitors, js-monitors

## [4.6.0] - 2020-12-14
### Added
- sos.management.wifi emits CLIENT_CONNECT_REJECTED event when incorrect credentials are used to try to connect to a Wi-Fi

## [4.5.0] - 2020-11-11
### Added
- Touch event from external touch device can be handled and further propagated to nested iFrames

## [4.4.0] - 2020-09-25
### Added
- Video orientation LANDSCAPE_FLIPPED
- Validations of all input parameters
- sos.hardware.openSerialPort() method to open and work with serial ports
- Typescript interfaces of generic button and RFID antenna that can be implemented by other libraries that implement a specific hardware

## [4.3.0] - 2020-09-01
### Fixed
- Font offline cache works for all platform same (using correct font file extension)
- Fixed a bug in WPEWebkit 2.28.2 (Raspberry Pi) that caused the applet to never initialize properly and freeze

### Added
- WiFi Access Point API
- WiFi API supports listening to useful events
- sos.appletVersion contains version of active applet

### Deprecated
- `sos.wifi` has been moved to `sos.management.wifi`

## [4.2.0] - 2020-07-02
### Added
- Audio codec and bitrate value in video file details API
- Browser open link method optionally accepts theme option

## [4.1.0] - 2020-06-23
### Added
- sos.management.debug.isEnabled() method for current debug state
- sos.management.security.setPinCode/getPinCode/generateRandomPinCode methods

### Fixed
- Possible memory leak in video player when one gapless video is playing in infinite loop

## [4.0.0] - 2020-04-03
### Added
- File System API supports copyFile, writeFile, readFile
- File System moveFile supports optional overwrite destination
- New Management JS API (https://sdk.docs.signageos.io/api/js/management/1-js-management)
- Video API supports video playing in the background with HTML content in the foreground
- Video API supports 4K video
- getTimers and unsetTimer of management power API
- setNTP of time API
- sensors API, for now just containing proximity sensor
- Exports for CommonJS users (standard for node.js `const sos = require('@signageos/front-applet')`). Also exports sos and monitoring properties
- sOS Open (bundled front-applet) support of iframes
- Transpile to EcmaScript 5
- Management get application version `sos.management.app.getVersion()`
- New Monitors JS API
- Video API supports volume for a single video
- Network API for set manual settings or DHCP `sos.management.network.setManual()` and `sos.management.network.setDHCP()`
- Browser API method `sos.browser.open()` which optionally allows to blacklist/whitelist specific domains
- Browser API method `sos.browser.close()`
- Optional videoThumbnailUriTemplate in file properties
- Upgrade App or Firmware can direct to specific file instead of special path template with version name

### Deprecated
- Network API for `sos.management.getNetworkInfo()` is currently moved to `sos.management.network.getActiveInfo()`
- Browser API method `sos.browser.openLink()` is replaced by `sos.browser.open()`.

### Fixed
- Now, error messages are more human readable (no more invocation error)
- Wifi scanDevices returns array

### Removed
- Remove deprecated exports
- Remove auto babel-polyfill

## [3.2.0] - 2019-01-24
### Added
- File System API supports writeFile

## [3.1.0] - 2019-01-18
### Added
- WiFi API
- sos.display.supports method to check, which capabilities device supports

## [3.0.0] - 2019-01-14
### Added
- File system API
- File system API supports even extended file info (size, mimeType, createdAt, lastModified, videoDuration) when device supports it (ex.: Linux)

### Changed
- sos.input is now EventEmitter instance type which supports classic event listening using methods on, once, addListener etc. for event 'keyup'

## [2.2.0] - 2018-12-14
### Added
- Front display can inject a script into the applet

## [2.1.0] - 2018-12-04
### Added
- New API for decompress (extract) ZIP (or other formats) files: https://sdk.docs.signageos.io/api/sos-applet-api/#Decompress_file_ZIP

### Fixed
- import lib in typescript using `import * as sos from '@signageos/front-applet';`
- interfaces of checksum (md5) methods

## [2.0.0] - 2018-09-17
### Added
- List offline files/contents (https://sdk.docs.signageos.io/api/sos-applet-api/#List_all_files)
- Delete offline files/contents (https://sdk.docs.signageos.io/api/sos-applet-api/#Delete_file)
- Allow use any npm module file imported as ES6 module (ex.: `import Video from '@signageos/front-applet/dist/FrontApplet/Video/Video'`)
- Binding of dispatched commands to REST API (https://sdk.docs.signageos.io/api/sos-applet-api/#Command_Receiving)
- New monitoring applet commands dispatching about `timing loaded`, `html snapshot`, `console logs`, `offline cache changes`, `video state changes` when monitoring is enabled by timing configuration `sos.config.sosMonitoring = true` or by dispatching command to device `sos.Monitoring.EnableMonitoring` (https://sdk.docs.signageos.io/api/sos-applet-api/#Monitoring_Commands)
- Methods for getting file checksum MD5: https://sdk.docs.signageos.io/api/sos-applet-api/#Checksum_file_md5
- Font face generator (https://sdk.docs.signageos.io/api/sos-applet-api/#Loading_fonts)

### Fixed
- Applet Commands type can has length 100 characters now
- Bug: onceEnded will be resolved always. (Bug could happen when preparing of next video was longer then length of current video)

### Removed
- old deprecated methods of sos.offline.cache (getFile, getContent)

## [1.3.2] - 2018-06-19
### Fixed
- In applets and iframes can be used babel-polyfill

## [1.3.1] - 2018-06-12
### Fixed
- Application can use window.dispatchEvent safely without error (TypeError: Cannot read property 'type' of undefined)

## [1.3.0] - 2018-05-30
### Added
- Remote control Key UP binding (https://sdk.docs.signageos.io/api/sos-applet-api/#input)

## [1.2.0] - 2018-05-09
### Added
- Changelog file containing all changes in current project
- @signageos/front-applet library is also published to public npm registry registry.npmjs.org https://sdk.docs.signageos.io/api/sos-applet-api/
