"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var child_process_promise_1 = require("child-process-promise");
var path = require("path");
var Debug = require("debug");
var querystring = require("querystring");
var debug = Debug('@signageos/file:index');
function file(filePath, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var fileBinPath, _a, args, separator, spawnProcess, rawResult, parsedResult, error_1;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, getFileBinPath(options)];
                case 1:
                    fileBinPath = _b.sent();
                    debug('bin', fileBinPath);
                    _a = createFileArguments(filePath, options), args = _a.args, separator = _a.separator;
                    debug('args', { args: args, separator: separator });
                    spawnProcess = child_process_promise_1.spawn(fileBinPath, args, { capture: ['stdout', 'stderr'] });
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, spawnProcess];
                case 3:
                    rawResult = _b.sent();
                    debug('raw result', rawResult);
                    parsedResult = parseResult(rawResult.stdout, separator, options);
                    debug('parsed result', parsedResult);
                    return [2 /*return*/, parsedResult];
                case 4:
                    error_1 = _b.sent();
                    console.error(error_1.stderr);
                    throw error_1;
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.default = file;
function getVersion(options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var fileBinPath, spawnProcess, rawResult, parsedResult, error_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getFileBinPath(options)];
                case 1:
                    fileBinPath = _a.sent();
                    debug('bin', fileBinPath);
                    spawnProcess = child_process_promise_1.spawn(fileBinPath, ['--version'], { capture: ['stdout', 'stderr'] });
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, spawnProcess];
                case 3:
                    rawResult = _a.sent();
                    debug('raw result', rawResult);
                    parsedResult = rawResult.stdout.toString().split('\n')[0];
                    return [2 /*return*/, parsedResult];
                case 4:
                    error_2 = _a.sent();
                    console.error(error_2.stderr);
                    throw error_2;
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.getVersion = getVersion;
var DEFAULT_UNIX_FILE_BIN_PATH = 'file';
var DEFAULT_WIN32_FILE_BIN_PATH = path.join(__dirname, 'win32', 'bin', 'file.exe');
function getFileBinPath(options) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            if (options.fileBinPath) {
                return [2 /*return*/, options.fileBinPath];
            }
            if (process.platform === 'win32') {
                return [2 /*return*/, DEFAULT_WIN32_FILE_BIN_PATH];
            }
            else {
                return [2 /*return*/, DEFAULT_UNIX_FILE_BIN_PATH];
            }
            return [2 /*return*/];
        });
    });
}
var DEFAULT_SEPARATOR = ':';
var DEFAULT_ALTERNATIVE_SEPARATORS = [';', '$', '€', '>', '<'];
function createFileArguments(filePath, options) {
    var _a, _b;
    var separator = (_a = options.separator) !== null && _a !== void 0 ? _a : DEFAULT_SEPARATOR;
    var alternativeSeparators = (_b = options.alternativeSeparators) !== null && _b !== void 0 ? _b : DEFAULT_ALTERNATIVE_SEPARATORS;
    var args = [];
    if (options.mimeType) {
        args.push('--mime');
    }
    var separatorIndex = 0;
    while (filePath.includes(separator)) {
        if (separatorIndex >= alternativeSeparators.length) {
            throw new Error("File path is incorrect: " + filePath + " . The separator cannot be determined from list: " + alternativeSeparators.join(','));
        }
        separator = alternativeSeparators[separatorIndex];
        separatorIndex++;
    }
    args.push('--separator', separator);
    args.push(filePath);
    return { args: args, separator: separator };
}
function parseResult(rawResult, separator, options) {
    return __awaiter(this, void 0, void 0, function () {
        var values, parsed, mimeValues, parsedExtra, typeValues;
        return __generator(this, function (_a) {
            values = rawResult.substring(rawResult.indexOf(separator) + 1);
            parsed = {};
            if (options.mimeType) {
                mimeValues = values.split(';');
                debug('mime values', mimeValues);
                parsed.mimeType = mimeValues[0].trim();
                if (mimeValues.length > 1) {
                    parsedExtra = querystring.decode(mimeValues[1].trim());
                    parsed.charset = parsedExtra.charset;
                }
            }
            else {
                typeValues = values.split(',');
                parsed.types = typeValues.map(function (type) { return type.trim(); });
            }
            return [2 /*return*/, parsed];
        });
    });
}
//# sourceMappingURL=index.js.map