"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrganizationsManager = void 0;
const runtime = __importStar(require("../../../lib/runtime.js"));
const { BaseAPI } = runtime;
/**
 *
 */
class OrganizationsManager extends BaseAPI {
    /**
     * Delete connections from an organization
     *
     * @throws {RequiredError}
     */
    async deleteEnabledConnection(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'connectionId']);
        const response = await this.request({
            path: `/organizations/{id}/enabled_connections/{connectionId}`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{connectionId}', encodeURIComponent(String(requestParameters.connectionId))),
            method: 'DELETE',
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    /**
     * Delete an invitation to organization
     *
     * @throws {RequiredError}
     */
    async deleteInvitation(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'invitation_id']);
        const response = await this.request({
            path: `/organizations/{id}/invitations/{invitation_id}`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{invitation_id}', encodeURIComponent(String(requestParameters.invitation_id))),
            method: 'DELETE',
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    /**
     * Delete members from an organization
     *
     * @throws {RequiredError}
     */
    async deleteMembers(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/members`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    /**
     * Remove one or more roles from a given user in the context of the provided organization
     *
     * @throws {RequiredError}
     */
    async deleteMemberRoles(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'user_id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/members/{user_id}/roles`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{user_id}', encodeURIComponent(String(requestParameters.user_id))),
            method: 'DELETE',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    /**
     * Delete a specific organization
     *
     * Delete organization
     *
     * @throws {RequiredError}
     */
    async delete(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const response = await this.request({
            path: `/organizations/{id}`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    async getEnabledConnections(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const queryParameters = runtime.applyQueryParams(requestParameters, [
            {
                key: 'page',
                config: {},
            },
            {
                key: 'per_page',
                config: {},
            },
            {
                key: 'include_totals',
                config: {},
            },
        ]);
        const response = await this.request({
            path: `/organizations/{id}/enabled_connections`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            query: queryParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get an enabled connection for an organization
     *
     * @throws {RequiredError}
     */
    async getEnabledConnection(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'connectionId']);
        const response = await this.request({
            path: `/organizations/{id}/enabled_connections/{connectionId}`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{connectionId}', encodeURIComponent(String(requestParameters.connectionId))),
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    async getInvitations(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const queryParameters = runtime.applyQueryParams(requestParameters, [
            {
                key: 'page',
                config: {},
            },
            {
                key: 'per_page',
                config: {},
            },
            {
                key: 'include_totals',
                config: {},
            },
            {
                key: 'fields',
                config: {},
            },
            {
                key: 'include_fields',
                config: {},
            },
            {
                key: 'sort',
                config: {},
            },
        ]);
        const response = await this.request({
            path: `/organizations/{id}/invitations`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            query: queryParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get an invitation to organization
     *
     * @throws {RequiredError}
     */
    async getInvitation(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'invitation_id']);
        const queryParameters = runtime.applyQueryParams(requestParameters, [
            {
                key: 'fields',
                config: {},
            },
            {
                key: 'include_fields',
                config: {},
            },
        ]);
        const response = await this.request({
            path: `/organizations/{id}/invitations/{invitation_id}`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{invitation_id}', encodeURIComponent(String(requestParameters.invitation_id))),
            method: 'GET',
            query: queryParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    async getMembers(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const queryParameters = runtime.applyQueryParams(requestParameters, [
            {
                key: 'page',
                config: {},
            },
            {
                key: 'per_page',
                config: {},
            },
            {
                key: 'include_totals',
                config: {},
            },
            {
                key: 'from',
                config: {},
            },
            {
                key: 'take',
                config: {},
            },
            {
                key: 'fields',
                config: {},
            },
            {
                key: 'include_fields',
                config: {},
            },
        ]);
        const response = await this.request({
            path: `/organizations/{id}/members`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            query: queryParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get a specific organization by name
     *
     * Get organization by name
     *
     * @throws {RequiredError}
     */
    async getByName(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['name']);
        const response = await this.request({
            path: `/organizations/name/{name}`.replace('{name}', encodeURIComponent(String(requestParameters.name))),
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    async getMemberRoles(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'user_id']);
        const queryParameters = runtime.applyQueryParams(requestParameters, [
            {
                key: 'page',
                config: {},
            },
            {
                key: 'per_page',
                config: {},
            },
            {
                key: 'include_totals',
                config: {},
            },
        ]);
        const response = await this.request({
            path: `/organizations/{id}/members/{user_id}/roles`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{user_id}', encodeURIComponent(String(requestParameters.user_id))),
            method: 'GET',
            query: queryParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    async getAll(requestParameters = {}, initOverrides) {
        const queryParameters = runtime.applyQueryParams(requestParameters, [
            {
                key: 'page',
                config: {},
            },
            {
                key: 'per_page',
                config: {},
            },
            {
                key: 'include_totals',
                config: {},
            },
            {
                key: 'from',
                config: {},
            },
            {
                key: 'take',
                config: {},
            },
            {
                key: 'sort',
                config: {},
            },
        ]);
        const response = await this.request({
            path: `/organizations`,
            method: 'GET',
            query: queryParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get a specific organization
     *
     * Get organization
     *
     * @throws {RequiredError}
     */
    async get(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const response = await this.request({
            path: `/organizations/{id}`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Modify an enabled_connection belonging to an Organization.
     *
     * Modify an Organizations Connection
     *
     * @throws {RequiredError}
     */
    async updateEnabledConnection(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'connectionId']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/enabled_connections/{connectionId}`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{connectionId}', encodeURIComponent(String(requestParameters.connectionId))),
            method: 'PATCH',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Modify an organization
     *
     * Modify an Organization
     *
     * @throws {RequiredError}
     */
    async update(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Add connections to an organization
     *
     * @throws {RequiredError}
     */
    async addEnabledConnection(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/enabled_connections`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Create invitations to organization
     *
     * @throws {RequiredError}
     */
    async createInvitation(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/invitations`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Add members to an organization
     *
     * @throws {RequiredError}
     */
    async addMembers(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/members`.replace('{id}', encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    /**
     * Assign one or more roles to a given user that will be applied in the context of the provided organization
     *
     * @throws {RequiredError}
     */
    async addMemberRoles(requestParameters, bodyParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['id', 'user_id']);
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations/{id}/members/{user_id}/roles`
                .replace('{id}', encodeURIComponent(String(requestParameters.id)))
                .replace('{user_id}', encodeURIComponent(String(requestParameters.user_id))),
            method: 'POST',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.VoidApiResponse.fromResponse(response);
    }
    /**
     * Create an organization
     *
     * Create an Organization
     *
     * @throws {RequiredError}
     */
    async create(bodyParameters, initOverrides) {
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/organizations`,
            method: 'POST',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
}
exports.OrganizationsManager = OrganizationsManager;
//# sourceMappingURL=organizations-manager.js.map