"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertWeekday = void 0;
const PowerTimerWeekday_1 = __importDefault(require("./Power/PowerTimerWeekday"));
const PowerTimerWeekdayEnum_1 = __importStar(require("./Power/PowerTimerWeekdayEnum"));
exports.convertWeekday = {
    fromShort(weekdays) {
        return {
            toLegacy() {
                return {
                    sun: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SUNDAY),
                    mon: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.MONDAY),
                    tue: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.TUESDAY),
                    wed: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.WEDNESDAY),
                    thu: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.THURSDAY),
                    fri: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.FRIDAY),
                    sat: weekdays.includes(PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SATURDAY),
                };
            },
            toLong() {
                return weekdays.map(convertShortWeekdayToLongWeekday);
            },
            toTimerWeekday() {
                return weekdays.map(convertShortWeekdayToTimerWeekday);
            },
        };
    },
    fromLong(weekdays) {
        return {
            toShort() {
                return weekdays.map(convertLongWeekdayToShortWeekday);
            },
            toLegacy() {
                return {
                    sun: weekdays.includes(PowerTimerWeekdayEnum_1.default.SUNDAY),
                    mon: weekdays.includes(PowerTimerWeekdayEnum_1.default.MONDAY),
                    tue: weekdays.includes(PowerTimerWeekdayEnum_1.default.TUESDAY),
                    wed: weekdays.includes(PowerTimerWeekdayEnum_1.default.WEDNESDAY),
                    thu: weekdays.includes(PowerTimerWeekdayEnum_1.default.THURSDAY),
                    fri: weekdays.includes(PowerTimerWeekdayEnum_1.default.FRIDAY),
                    sat: weekdays.includes(PowerTimerWeekdayEnum_1.default.SATURDAY),
                };
            },
            toTimerWeekday() {
                return weekdays.map(convertLongWeekdayToTimerWeekday);
            },
        };
    },
    fromLegacy(weekdays) {
        return {
            toShort() {
                return legacyTimerKeys.filter((key) => weekdays[key]);
            },
            toLong() {
                return legacyTimerKeys.filter((key) => weekdays[key]).map(convertShortWeekdayToLongWeekday);
            },
            toTimerWeekday() {
                return legacyTimerKeys.filter((key) => weekdays[key]).map((short) => PowerTimerWeekday_1.default[short]);
            },
        };
    },
    fromTimerWeekday(weekdays) {
        return {
            toShort() {
                return weekdays.map(convertTimerWeekdayToShortWeekday);
            },
            toLegacy() {
                return {
                    sun: weekdays.includes(PowerTimerWeekday_1.default.sun),
                    mon: weekdays.includes(PowerTimerWeekday_1.default.mon),
                    tue: weekdays.includes(PowerTimerWeekday_1.default.tue),
                    wed: weekdays.includes(PowerTimerWeekday_1.default.wed),
                    thu: weekdays.includes(PowerTimerWeekday_1.default.thu),
                    fri: weekdays.includes(PowerTimerWeekday_1.default.fri),
                    sat: weekdays.includes(PowerTimerWeekday_1.default.sat),
                };
            },
            toLong() {
                return weekdays.map((w) => convertShortWeekdayToLongWeekday(convertTimerWeekdayToShortWeekday(w)));
            },
        };
    },
};
function convertShortWeekdayToLongWeekday(shortWeekday) {
    switch (shortWeekday) {
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SUNDAY:
            return PowerTimerWeekdayEnum_1.default.SUNDAY;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.MONDAY:
            return PowerTimerWeekdayEnum_1.default.MONDAY;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.TUESDAY:
            return PowerTimerWeekdayEnum_1.default.TUESDAY;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.WEDNESDAY:
            return PowerTimerWeekdayEnum_1.default.WEDNESDAY;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.THURSDAY:
            return PowerTimerWeekdayEnum_1.default.THURSDAY;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.FRIDAY:
            return PowerTimerWeekdayEnum_1.default.FRIDAY;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SATURDAY:
            return PowerTimerWeekdayEnum_1.default.SATURDAY;
        default:
            throw new Error(`Unknown short weekday: ${shortWeekday}`);
    }
}
function convertShortWeekdayToTimerWeekday(shortWeekday) {
    switch (shortWeekday) {
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SUNDAY:
            return PowerTimerWeekday_1.default.sun;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.MONDAY:
            return PowerTimerWeekday_1.default.mon;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.TUESDAY:
            return PowerTimerWeekday_1.default.tue;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.WEDNESDAY:
            return PowerTimerWeekday_1.default.wed;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.THURSDAY:
            return PowerTimerWeekday_1.default.thu;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.FRIDAY:
            return PowerTimerWeekday_1.default.fri;
        case PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SATURDAY:
            return PowerTimerWeekday_1.default.sat;
        default:
            throw new Error(`Unknown short weekday: ${shortWeekday}`);
    }
}
function convertLongWeekdayToTimerWeekday(shortWeekday) {
    switch (shortWeekday) {
        case PowerTimerWeekdayEnum_1.default.SUNDAY:
            return PowerTimerWeekday_1.default.sun;
        case PowerTimerWeekdayEnum_1.default.MONDAY:
            return PowerTimerWeekday_1.default.mon;
        case PowerTimerWeekdayEnum_1.default.TUESDAY:
            return PowerTimerWeekday_1.default.tue;
        case PowerTimerWeekdayEnum_1.default.WEDNESDAY:
            return PowerTimerWeekday_1.default.wed;
        case PowerTimerWeekdayEnum_1.default.THURSDAY:
            return PowerTimerWeekday_1.default.thu;
        case PowerTimerWeekdayEnum_1.default.FRIDAY:
            return PowerTimerWeekday_1.default.fri;
        case PowerTimerWeekdayEnum_1.default.SATURDAY:
            return PowerTimerWeekday_1.default.sat;
        default:
            throw new Error(`Unknown short weekday: ${shortWeekday}`);
    }
}
function convertLongWeekdayToShortWeekday(longWeekday) {
    switch (longWeekday) {
        case PowerTimerWeekdayEnum_1.default.SUNDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SUNDAY;
        case PowerTimerWeekdayEnum_1.default.MONDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.MONDAY;
        case PowerTimerWeekdayEnum_1.default.TUESDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.TUESDAY;
        case PowerTimerWeekdayEnum_1.default.WEDNESDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.WEDNESDAY;
        case PowerTimerWeekdayEnum_1.default.THURSDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.THURSDAY;
        case PowerTimerWeekdayEnum_1.default.FRIDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.FRIDAY;
        case PowerTimerWeekdayEnum_1.default.SATURDAY:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SATURDAY;
        default:
            throw new Error(`Unknown long weekday: ${longWeekday}`);
    }
}
function convertTimerWeekdayToShortWeekday(timerWeekday) {
    switch (timerWeekday) {
        case PowerTimerWeekday_1.default.sun:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SUNDAY;
        case PowerTimerWeekday_1.default.mon:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.MONDAY;
        case PowerTimerWeekday_1.default.tue:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.TUESDAY;
        case PowerTimerWeekday_1.default.wed:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.WEDNESDAY;
        case PowerTimerWeekday_1.default.thu:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.THURSDAY;
        case PowerTimerWeekday_1.default.fri:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.FRIDAY;
        case PowerTimerWeekday_1.default.sat:
            return PowerTimerWeekdayEnum_1.ShortWeekdayEnum.SATURDAY;
        default:
            throw new Error(`Unknown timer weekday: ${timerWeekday}`);
    }
}
const legacyTimerKeys = ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat'];
//# sourceMappingURL=convertWeekday.js.map