"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.routeAliveness = routeAliveness;
const http_status_1 = __importDefault(require("http-status"));
/**
 * Runs aliveness check and serves the result
 *
 * Responds with 200 if service is alive.
 * Typically used by Kubernetes aliveness probe.
 *
 * If no isAlive callback is provided, the route will always respond with 200 as long as the application didn't freeze.
 */
function routeAliveness({ router, isAlive }) {
    router.get('/alive', (_req, res) => __awaiter(this, void 0, void 0, function* () {
        if (isAlive) {
            const alive = yield isAlive();
            const status = alive ? http_status_1.default.OK : http_status_1.default.SERVICE_UNAVAILABLE;
            res.sendStatus(status);
        }
        else {
            res.sendStatus(http_status_1.default.OK);
        }
    }));
}
//# sourceMappingURL=aliveness.js.map