"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPostgreSqlConnection = createPostgreSqlConnection;
const pg_promise_1 = __importDefault(require("pg-promise"));
const wait_1 = __importDefault(require("../Timer/wait"));
const genericGracefulExit_1 = require("../Events/genericGracefulExit");
const ConnectionParameters = require('pg/lib/connection-parameters');
function createPostgreSqlConnection(postgreDsn, poolSize = 10, onExit) {
    const config = new ConnectionParameters(postgreDsn);
    config.max = poolSize;
    config.keepAlive = true;
    const reconnectTimeout = 30e3;
    const gracefulExit = new genericGracefulExit_1.GenericGracefulExit('postgres', reconnectTimeout, onExit);
    const pgp = (0, pg_promise_1.default)({
        error: (_err, e) => __awaiter(this, void 0, void 0, function* () {
            if (e.cn) {
                yield gracefulExit.waitToConnectOrDie();
            }
        }),
        connect: (_client, _dc, _useCount) => {
            gracefulExit.connected();
        },
    });
    const connection = pgp(config);
    return {
        connection,
        connect() {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, wait_1.default)(1e3);
            });
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                pgp.end();
            });
        },
        addListener() {
            // TODO implement
        },
        removeListener() {
            // TODO implement
        },
    };
}
//# sourceMappingURL=postgreSqlConnectionFactory.js.map