"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDefaultNpmCredentialsProvider = createDefaultNpmCredentialsProvider;
exports.createStaticNpmCredentialsProvider = createStaticNpmCredentialsProvider;
exports.createAwsNpmCredentialsProvider = createAwsNpmCredentialsProvider;
const client_codeartifact_1 = require("@aws-sdk/client-codeartifact");
/**
 * Uses credentials from environment variables, if present
 */
function createDefaultNpmCredentialsProvider() {
    return () => __awaiter(this, void 0, void 0, function* () {
        return ({
            host: process.env.NPM_REGISTRY_HOST,
            url: process.env.NPM_REGISTRY_URL,
            authToken: process.env.NPM_AUTH_TOKEN,
        });
    });
}
function createStaticNpmCredentialsProvider(credentials) {
    return () => __awaiter(this, void 0, void 0, function* () { return credentials; });
}
function createAwsNpmCredentialsProvider({ domain, domainOwner, repository, region, }) {
    return () => __awaiter(this, void 0, void 0, function* () {
        const codeArtifact = new client_codeartifact_1.CodeartifactClient({ region });
        try {
            const getRepositoryEndpointCommand = new client_codeartifact_1.GetRepositoryEndpointCommand({
                domain,
                domainOwner,
                repository,
                format: 'npm',
            });
            const { repositoryEndpoint } = yield codeArtifact.send(getRepositoryEndpointCommand);
            if (!repositoryEndpoint) {
                throw new Error("Couldn't get repository endpoint");
            }
            const getAuthorizationTokenCommand = new client_codeartifact_1.GetAuthorizationTokenCommand({ domain, domainOwner });
            const { authorizationToken } = yield codeArtifact.send(getAuthorizationTokenCommand);
            if (!authorizationToken) {
                throw new Error("Couldn't get authorization token");
            }
            return {
                host: repositoryEndpoint.replace(/^https?:\/\//, '').replace(/\/$/, ''),
                url: repositoryEndpoint,
                authToken: authorizationToken,
            };
        }
        catch (error) {
            throw error;
        }
        finally {
            codeArtifact.destroy();
        }
    });
}
//# sourceMappingURL=NpmCredentialsProvider.js.map