"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ordinary = ordinary;
const helper_1 = require("../helper");
const timeout_1 = require("../../../Timer/timeout");
const CONNECTION_TIMEOUT = 5e3;
function ordinary(parsedDsn, originalDsn) {
    return __awaiter(this, void 0, void 0, function* () {
        let firstAvailableHost = undefined;
        for (const host of parsedDsn.hosts) {
            try {
                yield (0, timeout_1.withTimeout)((0, helper_1.tryConnection)(host, parsedDsn), CONNECTION_TIMEOUT);
                firstAvailableHost = host;
                break;
            }
            catch (error) {
                console.error('Not available host', host, error);
            }
        }
        if (!firstAvailableHost) {
            throw new Error(`No available connection string (DSN) found: ${originalDsn}`);
        }
        const selectedDsn = (0, helper_1.getDsn)(firstAvailableHost, parsedDsn);
        return selectedDsn;
    });
}
//# sourceMappingURL=ordinary.js.map