"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createInfluxdbConnection = createInfluxdbConnection;
const influxdb_client_1 = require("@influxdata/influxdb-client");
function createInfluxdbConnection(baseUrl, token, organization, bucket) {
    let influxDBClient = null;
    return {
        connect: (...args_1) => __awaiter(this, [...args_1], void 0, function* (timeout = 30e3) {
            influxDBClient = new influxdb_client_1.InfluxDB({ url: baseUrl, token: token, timeout });
        }),
        getClient: () => {
            if (influxDBClient) {
                return influxDBClient;
            }
            throw new Error('Client was closed.');
        },
        close: () => __awaiter(this, void 0, void 0, function* () {
            influxDBClient = null;
        }),
        getOrganization: () => organization,
        getBucket: () => bucket,
    };
}
//# sourceMappingURL=influxDBConnectionFactory.js.map