"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUniqueHash = generateUniqueHash;
exports.generateSalt = generateSalt;
const crypto_1 = require("crypto");
function generateUniqueHash(length = 50) {
    const hash = (0, crypto_1.createHash)('sha256');
    hash.update('' + new Date().valueOf() + Math.random());
    return hash.digest('hex').substring(0, length);
}
function generateSalt(length) {
    return (0, crypto_1.randomBytes)(length).toString('hex').substring(0, length);
}
//# sourceMappingURL=generator.js.map