"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.withMemoryCache = withMemoryCache;
const DEFAULT_CACHE_TTL_MS = 60 * 60 * 1e3; // 1 hour
function isCacheExpired(cache, ttlMs = DEFAULT_CACHE_TTL_MS) {
    const currentDate = new Date();
    return currentDate.getTime() - cache.fetchedAt.getTime() >= ttlMs;
}
function withMemoryCache(originalFunction, keyGetter, options) {
    const cache = {};
    const cachedFunction = function (...args) {
        return __awaiter(this, void 0, void 0, function* () {
            const key = keyGetter(...args);
            const entry = cache[key];
            if (entry && !isCacheExpired(entry, options === null || options === void 0 ? void 0 : options.ttlMs)) {
                return entry.data;
            }
            const result = yield originalFunction(...args);
            cache[key] = {
                data: result,
                fetchedAt: new Date(),
            };
            return result;
        });
    };
    cachedFunction.invalidate = (key) => {
        delete cache[key];
    };
    return cachedFunction;
}
//# sourceMappingURL=memoryCache.js.map