import IEvent, { IEventPayload } from '../IEvent';
import { EventCallback, IEventConsumer } from './IEventConsumer';
/**
 * In-memory implementation of IEventConsumer
 *
 * Main use case is for testing so that the tests are not dependent on AMQP or other external services
 */
export declare class InMemoryEventConsumer implements IEventConsumer {
    private emitter;
    addEventConsumer<TPayload extends IEventPayload>(eventType: string, callback: EventCallback<TPayload>): Promise<void>;
    /**
     * Will deliver the event to all consumers that were added via addEventConsumer
     */
    emitEvent<TPayload extends IEventPayload>(event: IEvent<TPayload>): Promise<void>;
}
