"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatIfZodError = exports.formatZodError = exports.FormattedZodError = exports.formatZodErrorMessage = void 0;
exports.isZodError = isZodError;
exports.isExternalZodError = isExternalZodError;
var zod_1 = require("zod");
/**
 * Detect whether the object is a ZodError (instance of ZodError could not work)
 */
function isZodError(error) {
    if (!error || typeof error !== 'object' || !('name' in error)) {
        return false;
    }
    return error instanceof zod_1.ZodError || (error.name === 'ZodError' && 'issues' in error);
}
/**
 * Detect whether the object is an external error with Zod-like originalError inside
 */
function isExternalZodError(error) {
    if (!error || typeof error !== 'object') {
        return false;
    }
    return 'originalError' in error && typeof error.originalError === 'object' && isZodError(error.originalError);
}
var formatZodErrorMessage = function (error) {
    return error.issues.map(function (issue) { return "".concat(issue.path.length > 0 ? issue.path + ': ' : '').concat(issue.message); }).join('\n');
};
exports.formatZodErrorMessage = formatZodErrorMessage;
var FormattedZodError = /** @class */ (function (_super) {
    __extends(FormattedZodError, _super);
    function FormattedZodError(message, zodError) {
        var _this = _super.call(this, message) || this;
        _this.zodError = zodError;
        Object.setPrototypeOf(_this, FormattedZodError.prototype);
        return _this;
    }
    return FormattedZodError;
}(Error));
exports.FormattedZodError = FormattedZodError;
/**
 * Returns the alternative instance of FormettedZodError
 * that contains the original zodError but the message
 * is formatted as a human readable single string.
 */
var formatZodError = function (error) {
    var message = (0, exports.formatZodErrorMessage)(error);
    return new FormattedZodError(message, error);
};
exports.formatZodError = formatZodError;
/**
 * Format only if the error is ZodError
 * @see formatZodError
 */
var formatIfZodError = function (error) {
    if (isZodError(error)) {
        return (0, exports.formatZodError)(error);
    }
    return error;
};
exports.formatIfZodError = formatIfZodError;
//# sourceMappingURL=zodError.js.map