type PickDefined<T> = {
    [P in keyof T]: T[P] extends undefined ? never : T[P];
};
/**
 * @param input can be any object
 * @param omittedValue value which should be omitted, currently supports `undefined`,
 *  `null`, `exact number`, `exact string` and `exact date`
 * @returns the same object recursively but without fields with omitted value
 */
export declare const getObjectWithOmittedValuesBy: <T, U>(input: T, omittedValue: U) => U extends undefined ? PickDefined<T> : Partial<T>;
/**
 * Better typed version of Object.keys function returning Array of keyof types instead of Array of string types.
 */
export declare const getObjectKeys: <T>(o: T) => Extract<keyof T, string>[];
/** Return the same type of object but replace undefined and optional properties as nullable properties */
export type NullableFromPartial<T> = {
    [P in keyof T]-?: undefined extends T[P] ? T[P] | null : T[P];
};
export declare function convertObjectUndefinedPropertiesToNull<T>(obj: T): NullableFromPartial<T>;
export declare function mapObject<TKey extends string | number | symbol, TFrom, TTo>(settings: Record<TKey, TFrom>, transform: (from: TFrom) => TTo): Record<TKey, TTo>;
export {};
