import { Router } from 'express';
export type IsAliveCallback = () => Promise<boolean> | boolean;
export type AlivenessRouteArgs = {
    router: Router;
    /**
     * Callback to check if service is alive
     *
     * This can involve any kind of check that makes sense in the context of a particular service.
     */
    isAlive?: IsAliveCallback;
};
/**
 * Runs aliveness check and serves the result
 *
 * Responds with 200 if service is alive.
 * Typically used by Kubernetes aliveness probe.
 *
 * If no isAlive callback is provided, the route will always respond with 200 as long as the application didn't freeze.
 */
export declare function routeAliveness({ router, isAlive }: AlivenessRouteArgs): void;
