"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeObservables = mergeObservables;
exports.asyncMap = asyncMap;
exports.flatten = flatten;
function mergeObservables() {
    var observables = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        observables[_i] = arguments[_i];
    }
    return new Observable(function (observer) {
        var observings = observables.map(function (observable) {
            var resolved = false;
            var resolve;
            var completePromise = new Promise(function (doResolve) {
                if (resolved) {
                    doResolve();
                }
                else {
                    resolve = doResolve;
                }
            });
            var subscription = observable.subscribe(function (value) { return observer.next(value); }, function (error) { return observer.error(error); }, function () { return (resolve ? resolve() : (resolved = true)); });
            return {
                subscription: subscription,
                completePromise: completePromise,
            };
        });
        Promise.all(observings.map(function (observing) { return observing.completePromise; })).then(function () { return observer.complete(); });
        return function () {
            observings.forEach(function (observing) { return observing.subscription.unsubscribe(); });
        };
    });
}
function asyncMap(observable, mapCallback) {
    var _this = this;
    return new Observable(function (observer) {
        var inputSubscription = observable.subscribe(function (inputValue) { return __awaiter(_this, void 0, void 0, function () {
            var outputValue, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, mapCallback(inputValue)];
                    case 1:
                        outputValue = _a.sent();
                        observer.next(outputValue);
                        return [3 /*break*/, 3];
                    case 2:
                        error_1 = _a.sent();
                        observer.error(error_1);
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/];
                }
            });
        }); }, function (error) { return observer.error(error); }, function () { return observer.complete(); });
        return function () {
            inputSubscription.unsubscribe();
        };
    });
}
function flatten(observable, depth) {
    var _this = this;
    if (depth === void 0) { depth = 1; }
    return new Observable(function (observer) {
        var subscription = observable.subscribe(function (values) { return __awaiter(_this, void 0, void 0, function () {
            var _i, _a, value;
            return __generator(this, function (_b) {
                for (_i = 0, _a = [values].flat(depth); _i < _a.length; _i++) {
                    value = _a[_i];
                    observer.next(value);
                }
                return [2 /*return*/];
            });
        }); }, function (error) { return observer.error(error); }, function () { return observer.complete(); });
        return function () {
            subscription.unsubscribe();
        };
    });
}
//# sourceMappingURL=helpers.js.map