"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAmqpConnection = createAmqpConnection;
var amqp = __importStar(require("amqplib"));
var events_1 = require("events");
var ChannelProvider_1 = __importDefault(require("./ChannelProvider"));
var QueuePublisher_1 = __importDefault(require("./QueuePublisher"));
var QueueSubscriber_1 = __importDefault(require("./QueueSubscriber"));
var debug_1 = __importDefault(require("debug"));
var genericGracefulExit_1 = require("../Events/genericGracefulExit");
var connection_1 = require("../ThirdParty/connection");
var createPool = require('generic-pool').createPool;
var debug = (0, debug_1.default)('@signageos/lib:AMQP:amqpConnectionFactory');
var defaultOptions = {
    priorityRange: 3,
    min: 1,
    max: 10,
    autostart: false,
    testOnBorrow: true,
    acquireTimeoutMillis: 3e3,
};
var defaultConnectionFactory = function (dsn) { return amqp.connect(dsn); };
function createAmqpConnection(dsn, options, onExit, 
/**
 * Option to provide own factory
 *
 * Especially useful in tests for mocking the connection
 */
connectionFactory) {
    if (options === void 0) { options = {}; }
    if (connectionFactory === void 0) { connectionFactory = defaultConnectionFactory; }
    var timeout = 30e3;
    var gracefulExit = new genericGracefulExit_1.GenericGracefulExit('rabbitmq', timeout, onExit);
    var emitter = new events_1.EventEmitter();
    var factory = {
        create: function () {
            return __awaiter(this, void 0, void 0, function () {
                var connection_2, e_1;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            debug('Create connection');
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 4]);
                            return [4 /*yield*/, connectionFactory(dsn)];
                        case 2:
                            connection_2 = _a.sent();
                            gracefulExit.connected();
                            connection_2.isClosed = false;
                            connection_2.on('error', function (error) {
                                debug(error); // exceptions are thrown in promises
                            });
                            connection_2.on('close', function () {
                                debug('Closed connection');
                                connection_2.isClosed = true;
                                emitter.emit(connection_1.ThirdPartyConnectionEvent.ConnectionClosed);
                            });
                            emitter.emit(connection_1.ThirdPartyConnectionEvent.ConnectionOpen);
                            return [2 /*return*/, connection_2];
                        case 3:
                            e_1 = _a.sent();
                            debug('Caught error: %O', e_1);
                            gracefulExit.waitToConnectOrDie();
                            return [3 /*break*/, 4];
                        case 4: return [2 /*return*/, Promise.reject(new Error('Unable to create connection AMQP'))];
                    }
                });
            });
        },
        destroy: function (connection) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            debug('Destroy connection');
                            if (!!connection.isClosed) return [3 /*break*/, 2];
                            return [4 /*yield*/, connection.close()];
                        case 1:
                            _a.sent();
                            emitter.emit(connection_1.ThirdPartyConnectionEvent.ConnectionClosed);
                            _a.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        },
        validate: function (connection) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    return [2 /*return*/, !connection.isClosed];
                });
            });
        },
    };
    options = __assign(__assign({}, defaultOptions), options);
    var pool = createPool(factory, options);
    pool.on('factoryCreateError', function (error) {
        debug('factoryCreateError %o', error);
        throw error;
    });
    pool.on('factoryDestroyError', function (error) {
        debug('factoryDestroyError %o', error);
        throw error;
    });
    var channelProvider = new ChannelProvider_1.default(pool);
    return {
        pool: pool,
        channelProvider: channelProvider,
        queuePublisher: new QueuePublisher_1.default(),
        queueSubscriber: new QueueSubscriber_1.default(),
        connect: function () {
            return __awaiter(this, void 0, void 0, function () {
                var initialConnection;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            debug('connect');
                            return [4 /*yield*/, pool.acquire()];
                        case 1:
                            initialConnection = _a.sent();
                            return [4 /*yield*/, pool.release(initialConnection)];
                        case 2:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
        close: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            debug('close');
                            return [4 /*yield*/, channelProvider.close()];
                        case 1:
                            _a.sent();
                            return [4 /*yield*/, pool.drain()];
                        case 2:
                            _a.sent();
                            pool.clear();
                            return [2 /*return*/];
                    }
                });
            });
        },
        addListener: function (event, listener) {
            emitter.addListener(event, listener);
        },
        removeListener: function (event, listener) {
            emitter.removeListener(event, listener);
        },
    };
}
//# sourceMappingURL=amqpConnectionFactory.js.map