"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppletSettingsSchema = void 0;
const zod_1 = require("zod");
const FinishEventType_1 = require("./FinishEventType");
exports.AppletSettingsSchema = zod_1.z.object({
    appletUid: zod_1.z.string(),
    appletVersion: zod_1.z.string(),
    /** @deprecated don't use anymore; will be removed in the future */
    startsAt: zod_1.z.date().optional(),
    /** @deprecated don't use anymore; will be removed in the future */
    endsAt: zod_1.z.date().optional(),
    configuration: zod_1.z.record(zod_1.z.string(), zod_1.z.unknown()),
    /** @deprecated don't use anymore; will be removed in the future */
    finishEvent: zod_1.z
        .object({
        type: FinishEventType_1.FinishEventTypeSchema,
        data: zod_1.z.any().optional(),
    })
        .optional(),
    /** @deprecated don't use anymore; will be removed in the future */
    position: zod_1.z.number().optional(),
});
