"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTimerSettingsPolicy = void 0;
exports.default = validateTimerSettingsPolicy;
exports.validateProprietaryTimerSettingsPolicy = validateProprietaryTimerSettingsPolicy;
const validateTimerSettings_1 = require("../../Device/Settings/Validation/validateTimerSettings");
const Validation_1 = require("../../Validation/Validation");
function validateTimerSettingsPolicy(settings) {
    const validation = (0, Validation_1.createValidation)(settings);
    if (!Array.isArray(settings)) {
        validation.addError(new InvalidTimerSettingsPolicy(settings));
    }
    else {
        settings === null || settings === void 0 ? void 0 : settings.forEach((setting) => {
            const settingValidation = (0, validateTimerSettings_1.default)(setting);
            validation.addError(...settingValidation.getErrors());
        });
    }
    return validation.getOutput();
}
function validateProprietaryTimerSettingsPolicy(settings) {
    const validation = (0, Validation_1.createValidation)(settings);
    if (!Array.isArray(settings)) {
        validation.addError(new InvalidTimerSettingsPolicy(settings));
    }
    else {
        settings === null || settings === void 0 ? void 0 : settings.forEach((setting) => {
            const settingValidation = (0, validateTimerSettings_1.validateProprietaryTimerSettings)(setting);
            validation.addError(...settingValidation.getErrors());
        });
    }
    return validation.getOutput();
}
class InvalidTimerSettingsPolicy extends Error {
    constructor(settings) {
        super(`Timer Settings Policy is not an array: ${settings}`);
    }
}
exports.InvalidTimerSettingsPolicy = InvalidTimerSettingsPolicy;
