import IPolicyItem from '../IPolicyItem';
import { ValidationOutput } from '../../Validation/Validation';
export type PolicyItemCandidate = Partial<IPolicyItem>;
export declare function validateAllPolicyItems<Item extends IPolicyItem = IPolicyItem>(policyItems: unknown): ValidationOutput<Item[]>;
export default function validatePolicyItem<Item extends IPolicyItem = IPolicyItem>(policyItem: unknown): ValidationOutput<Item>;
export declare function isPolicyItemMissingRequired(policyItem: unknown): boolean;
export declare function isValidPolicyItemApplicationType(type: unknown): boolean;
export declare class InvalidPolicyItems extends Error {
    constructor(policyItems: unknown);
}
export declare class InvalidPolicyItem extends Error {
    constructor(policyItem: unknown);
}
export declare class MissingRequiredValueField extends Error {
    constructor(value: unknown);
}
export declare class InvalidApplicationTypeField extends Error {
    constructor(type: unknown);
}
