"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidShortWeekday = exports.InvalidShortWeekdays = void 0;
exports.default = validateWeekdays;
const Validation_1 = require("../../../Validation/Validation");
const isValidShortWeekday_1 = require("./isValidShortWeekday");
function validateWeekdays(weekdays) {
    const validation = (0, Validation_1.createValidation)(weekdays);
    if (!Array.isArray(weekdays)) {
        validation.addError(new InvalidShortWeekdays(weekdays));
    }
    else {
        weekdays.forEach((weekday) => {
            const notValidWeekday = !(0, isValidShortWeekday_1.default)(weekday);
            if (notValidWeekday) {
                validation.addError(new InvalidShortWeekday(weekday));
            }
        });
    }
    return validation.getOutput();
}
class InvalidShortWeekdays extends Error {
    constructor(weekdays) {
        super(`Weekdays array is invalid: ${weekdays}`);
    }
}
exports.InvalidShortWeekdays = InvalidShortWeekdays;
class InvalidShortWeekday extends Error {
    constructor(weekday) {
        super(`Weekday in weekdays is not valid: ${weekday}`);
    }
}
exports.InvalidShortWeekday = InvalidShortWeekday;
