"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemLogPayloadSchemas = exports.PowerActionPerformedSchema = exports.PolicyChangedSchema = exports.AppletRunningSchema = exports.NetworkChangedSchema = exports.AppletStartedSchema = exports.ApplicationStartedSchema = exports.TimeSettingsChangedSchema = exports.DeviceAliveSchema = exports.SocketConnectionFailedSchema = exports.SocketDisconnectedSchema = exports.SocketConnectedSchema = exports.PowerActionPerformed = exports.PolicyChanged = exports.AppletRunning = exports.NetworkChanged = exports.AppletStarted = exports.ApplicationStarted = exports.TimeSettingsChanged = exports.DeviceAlive = exports.SocketConnectionFailed = exports.SocketDisconnected = exports.SocketConnected = void 0;
const zod_1 = require("zod");
const IPolicyItem_1 = require("../../Policy/IPolicyItem");
const NetworkInterface_1 = require("../Network/NetworkInterface");
const PowerActionType_1 = require("../Power/PowerActionType");
exports.SocketConnected = 'SocketConnected';
exports.SocketDisconnected = 'SocketDisconnected';
exports.SocketConnectionFailed = 'SocketConnectionFailed';
exports.DeviceAlive = 'DeviceAlive';
exports.TimeSettingsChanged = 'TimeSettingsChanged';
exports.ApplicationStarted = 'ApplicationStarted';
exports.AppletStarted = 'AppletStarted';
exports.NetworkChanged = 'NetworkChanged';
exports.AppletRunning = 'AppletRunning';
exports.PolicyChanged = 'PolicyChanged';
exports.PowerActionPerformed = 'PowerActionPerformed';
exports.SocketConnectedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.SocketConnected),
});
exports.SocketDisconnectedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.SocketDisconnected),
});
exports.SocketConnectionFailedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.SocketConnectionFailed),
    errorMessage: zod_1.z.string(),
});
exports.DeviceAliveSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.DeviceAlive),
});
exports.TimeSettingsChangedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.TimeSettingsChanged),
});
exports.ApplicationStartedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.ApplicationStarted),
    startedAt: zod_1.z.date(),
});
exports.AppletStartedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.AppletStarted),
    appletUid: zod_1.z.string(),
    appletVersion: zod_1.z.string(),
});
exports.NetworkChangedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.NetworkChanged),
    data: zod_1.z.array(NetworkInterface_1.NetworkInterfaceSchema),
});
exports.AppletRunningSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.AppletRunning),
    appletUid: zod_1.z.string(),
});
exports.PolicyChangedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.PolicyChanged),
    actual: zod_1.z.array(IPolicyItem_1.PolicyItemSchema),
    difference: zod_1.z.array(IPolicyItem_1.PolicyItemSchema),
    updatedAt: zod_1.z.number(),
});
exports.PowerActionPerformedSchema = zod_1.z.object({
    type: zod_1.z.literal(exports.PowerActionPerformed),
    action: zod_1.z.nativeEnum(PowerActionType_1.default),
});
exports.SystemLogPayloadSchemas = zod_1.z.discriminatedUnion('type', [
    exports.SocketConnectedSchema,
    exports.SocketDisconnectedSchema,
    exports.SocketConnectionFailedSchema,
    exports.DeviceAliveSchema,
    exports.TimeSettingsChangedSchema,
    exports.ApplicationStartedSchema,
    exports.AppletStartedSchema,
    exports.NetworkChangedSchema,
    exports.AppletRunningSchema,
    exports.PowerActionPerformedSchema,
    exports.PolicyChangedSchema,
]);
