import { Validation, ValidationOutput } from '../../../Validation/Validation';
import { NativeTimer, ProprietaryTimer } from '../DeviceSettings';
export declare const validNativeKeys: {
    [K in keyof Required<NativeTimer>]: true;
};
export declare const validProprietaryKeys: {
    [K in keyof Required<ProprietaryTimer>]: true;
};
export declare function validateNativeTimer(settings: unknown): ValidationOutput<NativeTimer>;
export declare function validateProprietaryTimer(settings: unknown): ValidationOutput<ProprietaryTimer>;
export declare function validateCommonTimer<T extends NativeTimer | ProprietaryTimer>(settings: unknown): Validation<T>;
