"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidPeerRecoverySettingsEnabled = exports.validKeys = void 0;
exports.default = validatePeerRecoverySettings;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    enabled: true,
};
function validatePeerRecoverySettings(settings) {
    var _a;
    const { enabled } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notEnabledValid = !(typeof enabled === 'boolean');
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notEnabledValid) {
        validation.addError(new InvalidPeerRecoverySettingsEnabled(enabled));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidPeerRecoverySettingsEnabled extends Error {
    constructor(enabled) {
        super(`Peer recovery settings field 'enabled' is not boolean: ${enabled}`);
    }
}
exports.InvalidPeerRecoverySettingsEnabled = InvalidPeerRecoverySettingsEnabled;
