"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidFirmwareVersion = exports.validKeys = void 0;
exports.default = validateFirmwareVersionSettings;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    version: true,
};
function validateFirmwareVersionSettings(settings) {
    var _a;
    const { version } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notVersionValid = !(typeof version === 'string' && version.length > 0);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notVersionValid) {
        validation.addError(new InvalidFirmwareVersion(version));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidFirmwareVersion extends Error {
    constructor(version) {
        super(`Firmware Version has to be string: ${version}`);
    }
}
exports.InvalidFirmwareVersion = InvalidFirmwareVersion;
