"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceSettingsType = void 0;
/**
 * All settings that can be set on the device. For example using policy.
 * All of them should be available as a DeviceTelemetryType with the same name as the setting.
 */
var DeviceSettingsType;
(function (DeviceSettingsType) {
    DeviceSettingsType["VOLUME"] = "VOLUME";
    DeviceSettingsType["BRIGHTNESS"] = "BRIGHTNESS";
    DeviceSettingsType["TIMERS"] = "TIMERS";
    DeviceSettingsType["PROPRIETARY_TIMERS"] = "PROPRIETARY_TIMERS";
    DeviceSettingsType["RESOLUTION"] = "RESOLUTION";
    DeviceSettingsType["ORIENTATION"] = "ORIENTATION";
    DeviceSettingsType["REMOTE_CONTROL"] = "REMOTE_CONTROL";
    DeviceSettingsType["APPLICATION_VERSION"] = "APPLICATION_VERSION";
    DeviceSettingsType["FIRMWARE_VERSION"] = "FIRMWARE_VERSION";
    DeviceSettingsType["DEBUG"] = "DEBUG";
    DeviceSettingsType["DATETIME"] = "DATETIME";
    DeviceSettingsType["POWER_ACTIONS_SCHEDULE"] = "POWER_ACTIONS_SCHEDULE";
    DeviceSettingsType["TEMPERATURE"] = "TEMPERATURE";
    DeviceSettingsType["AUTO_RECOVERY"] = "AUTO_RECOVERY";
    DeviceSettingsType["PEER_RECOVERY"] = "PEER_RECOVERY";
    DeviceSettingsType["PROXY"] = "PROXY";
    DeviceSettingsType["CONNECTION_METHOD"] = "CONNECTION_METHOD";
    DeviceSettingsType["PACKAGES"] = "PACKAGES";
    DeviceSettingsType["TELEMETRY_INTERVALS"] = "TELEMETRY_INTERVALS";
    DeviceSettingsType["APPLET"] = "APPLET";
    DeviceSettingsType["EXTENDED_MANAGEMENT"] = "EXTENDED_MANAGEMENT";
    DeviceSettingsType["NETWORK_INTERFACES"] = "NETWORK_INTERFACES";
    DeviceSettingsType["DISPLAY_POWER_ON"] = "DISPLAY_POWER_ON";
    DeviceSettingsType["SCREENSHOT_CAPTURE"] = "SCREENSHOT_CAPTURE";
})(DeviceSettingsType || (exports.DeviceSettingsType = DeviceSettingsType = {}));
