import ApplicationType from '../../Application/ApplicationType';
import { ConfigValues } from '../../Configuration/configuration';
import { FinishEventType } from '../../Timing/FinishEventType';
import { AutoRecoveryDisabled, AutoRecoveryEnabled, PeerRecoveryDisabled, PeerRecoveryEnabled } from '../ActionLog/Recovery';
import { InputSource } from '../Input/InputSource';
import { TelemetryCheckIntervals } from '../MonitoringLog/TelemetryIntervals';
import { DeviceProvisioningRecipeStatus } from '../ProvisioningRecipe/deviceProvisioningRecipe';
import Orientation from '../Resolution/Orientation';
import { ResolutionItem } from '../Resolution/ResolutionList';
import VideoOrientation from '../Resolution/VideoOrientation';
import { NativeTimer, ProprietaryTimer } from '../Settings/DeviceSettings';
import { DeviceActionType } from './DeviceActionType';
export type DeviceActionData = {
    [DeviceActionType.SET_APPLICATION_VERSION]: {
        applicationType: ApplicationType;
        version: string;
    };
    [DeviceActionType.SET_VOLUME]: {
        volume: number;
    };
    [DeviceActionType.SET_RM_SERVER]: {
        rmServerUrl: string | null;
    };
    [DeviceActionType.SET_BRIGHTNESS]: {
        brightness1: number;
        brightness2: number;
        timeFrom1: string;
        timeFrom2: string;
    };
    [DeviceActionType.RECONNECT]: Record<string, never>;
    [DeviceActionType.UPDATE_CONFIGURATION]: ConfigValues;
    [DeviceActionType.UPDATE_TIME]: {
        timestamp: number;
        timezone: string | null;
        ntpServer?: string;
    };
    [DeviceActionType.SET_DEBUG]: {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    };
    [DeviceActionType.SET_FIRMWARE_VERSION]: {
        version: string;
    };
    [DeviceActionType.INSTALL_PACKAGE]: {
        packageName: string;
        applicationType: ApplicationType;
        buildHash: string;
        version: string;
        build: string | null;
        /** null is allowed for historical reason. The specific data are defined in common-types */
        specs: object | null;
    };
    [DeviceActionType.INSTALL_PACKAGE_FROM_URI]: {
        packageUri: string;
        /** null is allowed for historical data. It should be only "tizen" as default */
        applicationType: ApplicationType | null;
        /** The specific data ara defined in common-types for every applicationType */
        specs: object | null;
    };
    [DeviceActionType.UNINSTALL_PACKAGE]: {
        packageName: string;
        applicationType: ApplicationType;
        /** The specific data ara defined in common-types for every applicationType */
        specs: object;
    };
    [DeviceActionType.POWER_ACTION]: {
        powerType: string;
    };
    [DeviceActionType.SET_SCHEDULED_POWER_ACTION]: {
        powerType: string;
        weekdays: string[];
        time: string;
    };
    [DeviceActionType.CANCEL_SCHEDULED_POWER_ACTION]: {
        scheduledPowerActionUid: string;
    };
    [DeviceActionType.SET_VPN]: {
        enabled: boolean;
    };
    [DeviceActionType.SEND_APPLET_COMMAND]: {
        appletUid: string;
        command: {
            type: string;
            [key: string]: unknown;
        };
    };
    [DeviceActionType.SET_REMOTE_CONTROL]: {
        enabled: boolean;
    };
    [DeviceActionType.RESIZE]: {
        resolution: ResolutionItem;
        orientation: Orientation;
        videoOrientation?: VideoOrientation;
    };
    [DeviceActionType.PROVISION]: {
        verificationHash: string;
    };
    [DeviceActionType.DEPROVISION]: {
        verificationHash: string;
    };
    [DeviceActionType.UPDATE_NAME]: {
        name: string;
    };
    [DeviceActionType.BAN]: Record<string, never>;
    [DeviceActionType.APPROVE]: Record<string, never>;
    [DeviceActionType.CHANGE_SUBSCRIPTION_TYPE]: {
        subscriptionType: string | null;
    };
    [DeviceActionType.CREATE_TIMING]: {
        appletUid: string;
        appletVersion: string;
        /**
         * Timing will be active from startsAt to endsAt.
         * If not provided, the default value will be 1970-01-01.
         * @deprecated shouldn't be used anymore; will be removed in the future
         */
        startsAt: Date | undefined;
        /**
         * Timing will be active from startsAt to endsAt.
         * If not provided, the default value will be 2030-12-31.
         * @deprecated shouldn't be used anymore; will be removed in the future
         */
        endsAt: Date | undefined;
        configuration: Record<string, unknown>;
        /** @deprecated It stays because of backward compatibility and shouldn´t be used anymore in new implementations */
        finishEvent: {
            type: FinishEventType;
            data?: any;
        } | undefined;
        /** @deprecated It stays because of backward compatibility and shouldn´t be used anymore in new implementations */
        position: number | undefined;
        /**
         * If true, other timings on the same device will be disabled.
         * If not provided, default value will be generated from startsAt/endsAt based on the current time.
         * If neither startsAt nor endsAt is provided, the default value will be true.
         */
        active: boolean | undefined;
    };
    [DeviceActionType.UPDATE_TIMING]: {
        appletUid: string;
        appletVersion: string | undefined;
        /** @deprecated It stays because of backward compatibility and shouldn´t be used anymore in new implementations */
        startsAt: Date | undefined;
        /** @deprecated It stays because of backward compatibility and shouldn´t be used anymore in new implementations */
        endsAt: Date | undefined;
        configuration: Record<string, unknown> | undefined;
        configurationSet: Record<string, unknown> | undefined;
        configurationRemoveKeys: string[] | undefined;
        /** @deprecated It stays because of backward compatibility and shouldn´t be used anymore in new implementations */
        finishEvent: {
            type: FinishEventType | undefined;
            data?: any | undefined;
        } | undefined;
        /** @deprecated It stays because of backward compatibility and shouldn´t be used anymore in new implementations */
        position: number | undefined;
        /** If true, other timings on the same device will be disabled */
        active: boolean | undefined;
    };
    [DeviceActionType.DELETE_TIMING]: {
        uid: string;
        appletUid: string;
        appletVersion: string;
    };
    [DeviceActionType.SET_DEVICE_APPLET_TEST_SUITE]: {
        appletUid: string;
        appletVersion: string;
        tests: string[];
    };
    [DeviceActionType.SET_TEST_SUITE]: {
        tests: string[];
    };
    [DeviceActionType.START_PACKAGE]: {
        packageName: string;
        applicationType: ApplicationType;
    };
    [DeviceActionType.SET_TIMER]: NativeTimer;
    [DeviceActionType.SET_PROPRIETARY_TIMER]: ProprietaryTimer;
    [DeviceActionType.SET_POWER_STATUS]: {
        turnedOn: boolean;
    };
    [DeviceActionType.SET_INPUT_SOURCE]: {
        inputSource: InputSource;
    };
    [DeviceActionType.SET_DISPLAY_BACKLIGHT]: {
        /** Value in range 0-100 */
        backlight: number;
    };
    [DeviceActionType.SET_DISPLAY_CONTRAST]: {
        /** Value in range 0-100 */
        contrast: number;
    };
    [DeviceActionType.SET_DISPLAY_SHARPNESS]: {
        /** Value in range 0-100 */
        sharpness: number;
    };
    [DeviceActionType.SET_DISPLAY_TEMPERATURE_CONTROL]: {
        /** Maximum temperature while display is keeping turned on. Otherwise, it's usually turned of or switched to power saving mode */
        maxTemperature: number;
    };
    [DeviceActionType.SET_REMOTE_DESKTOP]: {
        enabled: boolean;
        /** URL where the remote desktop will be available (usually for limited amount of time) */
        remoteDesktopUri?: string;
        frequencyIntervalMs?: number;
    };
    [DeviceActionType.SET_POLICY]: {
        policyUid: string;
        /** Higher number means higher priority */
        priority: number;
    };
    [DeviceActionType.DELETE_POLICY]: {
        policyUid: string;
    };
    [DeviceActionType.UPDATE_POLICY]: {
        policyUid: string;
    };
    [DeviceActionType.SET_ORGANIZATION_TAGS]: {
        tagUids: string[];
    };
    [DeviceActionType.DELETE_ORGANIZATION_TAGS]: {
        tagUids: string[];
    };
    [DeviceActionType.SET_ORGANIZATION]: {
        organizationUid: string;
    };
    [DeviceActionType.SET_AUTO_RECOVERY]: AutoRecoveryEnabled | AutoRecoveryDisabled;
    [DeviceActionType.SET_PEER_RECOVERY]: PeerRecoveryEnabled | PeerRecoveryDisabled;
    [DeviceActionType.ENABLE_EXTENDED_TELEMETRY]: {
        duration: number;
    };
    [DeviceActionType.DISABLE_EXTENDED_TELEMETRY]: {};
    [DeviceActionType.UPDATE_TELEMETRY_CHECK_INTERVALS]: TelemetryCheckIntervals;
    [DeviceActionType.UPDATE_TELEMETRY_CHECK_INTERVAL]: TelemetryCheckIntervals;
    [DeviceActionType.TELEMETRY_INTERVALS]: {
        telemetryCheckIntervals: TelemetryCheckIntervals;
    };
    [DeviceActionType.UPDATE_PROVISIONING_RECIPE_STATUS]: {
        status: DeviceProvisioningRecipeStatus.APPLIED;
        provisioningRecipeUid: string;
    };
    [DeviceActionType.PROVISIONING_RECIPE_STATUS_UPDATED]: {
        status: DeviceProvisioningRecipeStatus.APPLIED;
        provisioningRecipeUid: string;
    };
    [DeviceActionType.SET_LOCATION]: {
        locationUid: string;
    };
    [DeviceActionType.DELETE_LOCATION]: {};
    [DeviceActionType.EXECUTE_CUSTOM_SCRIPT]: {
        configuration: Record<string, any>;
        customScriptUid: string;
        version: string;
    };
    [DeviceActionType.REVOKE_DEVICE_KEY]: {};
};
