import * as runtime from '../../../lib/runtime.js';
const { BaseAPI } = runtime;
/**
 *
 */
export class KeysManager extends BaseAPI {
    /**
     * Get an Application Signing Key by its key id
     *
     * @throws {RequiredError}
     */
    async get(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['kid']);
        const response = await this.request({
            path: `/keys/signing/{kid}`.replace('{kid}', encodeURIComponent(String(requestParameters.kid))),
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get all Application Signing Keys
     *
     * @throws {RequiredError}
     */
    async getAll(initOverrides) {
        const response = await this.request({
            path: `/keys/signing`,
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Rotate the Application Signing Key
     *
     * @throws {RequiredError}
     */
    async rotate(initOverrides) {
        const response = await this.request({
            path: `/keys/signing/rotate`,
            method: 'POST',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Revoke an Application Signing Key by its key id
     *
     * @throws {RequiredError}
     */
    async revoke(requestParameters, initOverrides) {
        runtime.validateRequiredRequestParams(requestParameters, ['kid']);
        const response = await this.request({
            path: `/keys/signing/{kid}/revoke`.replace('{kid}', encodeURIComponent(String(requestParameters.kid))),
            method: 'PUT',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
}
//# sourceMappingURL=keys-manager.js.map