import * as runtime from '../../../lib/runtime.js';
import type { InitOverride, ApiResponse } from '../../../lib/runtime.js';
import type { GetBreachedPasswordDetection200Response, GetBruteForceProtection200Response, GetSuspiciousIpThrottling200Response, PatchBreachedPasswordDetectionRequest, PatchBruteForceProtectionRequest, PatchSuspiciousIpThrottlingRequest } from '../models/index.js';
declare const BaseAPI: typeof runtime.BaseAPI;
/**
 *
 */
export declare class AttackProtectionManager extends BaseAPI {
    /**
     * Get breached password detection settings
     *
     * @throws {RequiredError}
     */
    getBreachedPasswordDetectionConfig(initOverrides?: InitOverride): Promise<ApiResponse<GetBreachedPasswordDetection200Response>>;
    /**
     * Get the brute force configuration
     *
     * @throws {RequiredError}
     */
    getBruteForceConfig(initOverrides?: InitOverride): Promise<ApiResponse<GetBruteForceProtection200Response>>;
    /**
     * Get the suspicious IP throttling configuration
     *
     * @throws {RequiredError}
     */
    getSuspiciousIpThrottlingConfig(initOverrides?: InitOverride): Promise<ApiResponse<GetSuspiciousIpThrottling200Response>>;
    /**
     * Update breached password detection settings
     *
     * @throws {RequiredError}
     */
    updateBreachedPasswordDetectionConfig(bodyParameters: PatchBreachedPasswordDetectionRequest, initOverrides?: InitOverride): Promise<ApiResponse<GetBreachedPasswordDetection200Response>>;
    /**
     * Update the brute force configuration
     *
     * @throws {RequiredError}
     */
    updateBruteForceConfig(bodyParameters: PatchBruteForceProtectionRequest, initOverrides?: InitOverride): Promise<ApiResponse<GetBruteForceProtection200Response>>;
    /**
     * Update the suspicious IP throttling configuration
     *
     * @throws {RequiredError}
     */
    updateSuspiciousIpThrottlingConfig(bodyParameters: PatchSuspiciousIpThrottlingRequest, initOverrides?: InitOverride): Promise<ApiResponse<GetSuspiciousIpThrottling200Response>>;
}
export {};
