# TODO: Replace with secret manager
#!/bin/bash

# This script is used to export environment variables from helm to env
# Values specififed in ENV_VARIABLE_NAMES are required for running tests locally or in the CI
FILE_NAME=".env.test.yaml"
FILE_PATH="$FILE_NAME"
TMP_FILE_PATH="$FILE_PATH.tmp"
EXPORTED_ENV_VARIABLES_PATH=".env.docker-compose"

sops --decrypt "$FILE_PATH" > "$TMP_FILE_PATH"

ENV_VARIABLE_NAMES=("auth0_database_connection_id" "auth0_notifier_client_id" "auth0_notifier_client_secret" "auth0_api_client_id" "auth0_api_client_secret" "auth0_api_test_user_password")
ENV_VARIABLES=$(grep -E "^($(IFS='|'; echo "${ENV_VARIABLE_NAMES[*]}")):" "$TMP_FILE_PATH")

for key in "${ENV_VARIABLE_NAMES[@]}"; do
    sed -i "/$key/d" "$EXPORTED_ENV_VARIABLES_PATH"
    value=$(echo "$ENV_VARIABLES" | grep "^${key}:" | cut -d':' -f2-)
    trimmed_value="${value#"${value%%[![:space:]]*}"}"
    parsed_env_variables="$key"="$trimmed_value"
    echo "$parsed_env_variables" >> "$EXPORTED_ENV_VARIABLES_PATH"
done

rm "$TMP_FILE_PATH"
