"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setIncreasingInterval = setIncreasingInterval;
exports.clearIncreasingInterval = clearIncreasingInterval;
const wait_1 = __importDefault(require("./wait"));
let lastId = 0;
let intervals = [];
function setIncreasingInterval(startInterval, increase, maxInterval, callback) {
    if (startInterval <= 0) {
        throw new Error('Starting interval must be a positive number');
    }
    if (typeof maxInterval === 'number' && maxInterval < startInterval) {
        throw new Error('Max interval must be higher than or equal to start interval');
    }
    if (typeof increase === 'number' && increase < 0) {
        throw new Error('Increase must be a non-negative number');
    }
    const id = ++lastId;
    intervals.push(id);
    handler(id, startInterval, increase, maxInterval, callback).catch(() => clearIncreasingInterval(id));
    return id;
}
function clearIncreasingInterval(clearId) {
    intervals = intervals.filter((id) => id !== clearId);
}
function handler(id, startInterval, increase, maxInterval, callback) {
    return __awaiter(this, void 0, void 0, function* () {
        let interval = startInterval;
        while (true) {
            yield (0, wait_1.default)(interval);
            if (intervals.indexOf(id) < 0) {
                break;
            }
            callback();
            interval = increaseInterval(interval, increase, maxInterval);
        }
    });
}
function increaseInterval(previousInterval, increase, maxInterval) {
    let newInterval;
    if (typeof increase === 'number') {
        newInterval = previousInterval + increase;
    }
    else if (typeof increase === 'function') {
        newInterval = increase(previousInterval);
    }
    else {
        throw new Error('Invalid increase value - must be either number or a function');
    }
    if (newInterval < previousInterval) {
        throw new Error('Unexpected value: interval decreased');
    }
    if (typeof maxInterval === 'number') {
        return Math.min(newInterval, maxInterval);
    }
    return newInterval;
}
//# sourceMappingURL=increasingInterval.js.map