"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = void 0;
const AsyncEventEmitter_1 = require("../Events/AsyncEventEmitter");
const process_1 = require("./process");
class Service {
    constructor(args) {
        this.eventEmitter = new AsyncEventEmitter_1.AsyncEventEmitter();
        this.started = false;
        this.httpServer = args.httpServer;
        this.metricsClient = args.metricsClient;
    }
    isStarted() {
        return this.started;
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.httpServer.listen();
            (0, process_1.handleSignals)(this);
            (0, process_1.suppressUncaughtExceptionsAndUnhandledRejections)();
            this.started = true;
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            console.info('Service is stopping');
            yield this.httpServer.close();
            yield this.eventEmitter.emit('stop');
            this.started = false;
            console.info('Service stopped');
        });
    }
    on(event, callback) {
        this.eventEmitter.on(event, callback);
        return this;
    }
    off(event, callback) {
        this.eventEmitter.off(event, callback);
        return this;
    }
}
exports.Service = Service;
//# sourceMappingURL=Service.js.map