import { Request, Response, NextFunction } from 'express';
export interface AccessLog {
    method: string;
    path: string;
    status: number;
    remoteAddress?: string;
    userAgent?: string;
    requestBytes: number;
    responseBytes: number;
    headers: Record<string, string>;
    referrer?: string;
    remoteUser?: string;
    tookSeconds?: number;
}
export type LogCallback = (accessLog: AccessLog, req: Request, res: Response) => void;
type ExtendedRequest = Request & {
    _startAt?: bigint;
};
export declare function accessLogMiddleware(logCallback: LogCallback): (req: ExtendedRequest, res: Response, next: NextFunction) => void;
export {};
