"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppExpress = createAppExpress;
const express = __importStar(require("express"));
const express_prom_bundle_1 = __importDefault(require("express-prom-bundle"));
const accessLogMiddleware_1 = require("../middleware/accessLogMiddleware");
const logging_1 = require("../../../Logging/logging");
const router_1 = require("../routes/app/router");
const expressFactory_1 = require("./expressFactory");
const headersMiddleware_1 = require("../middleware/headersMiddleware");
const accessLogLogger = logging_1.logger.createNamespace('accessLog');
function createAppExpress(args) {
    const { metricsClient, accessLogCallback, setDefaultPenTestHeaders } = args;
    const app = (0, expressFactory_1.createExpressApp)();
    // Log all requests
    app.use((0, accessLogMiddleware_1.accessLogMiddleware)((accessLog, req, res) => {
        accessLogLogger.info(`${accessLog.method} ${accessLog.path}`, Object.assign(Object.assign({}, accessLog), accessLogCallback === null || accessLogCallback === void 0 ? void 0 : accessLogCallback(accessLog, req, res)));
    }));
    if (setDefaultPenTestHeaders) {
        app.use((0, headersMiddleware_1.getHeadersMiddleware)());
        app.disable('x-powered-by');
    }
    // collects metrics from the express app for Prometheus
    app.use((0, express_prom_bundle_1.default)({
        includeMethod: true,
        includePath: true,
        includeStatusCode: true,
        metricType: 'histogram',
        normalizePath: (req) => {
            var _a, _b;
            // Return the path of the express route (i.e. /v1/user/:id or /v1/timer/automated/:userid/:timerid")
            return (_b = (_a = req.route) === null || _a === void 0 ? void 0 : _a.path) !== null && _b !== void 0 ? _b : 'NULL';
        },
        // buckets for the histogram, see https://prometheus.io/docs/concepts/metric_types/#histogram
        buckets: [0.003, 0.03, 0.1, 0.2, 0.5, 1, 2, 5, 10, 30, 60],
        // prom-bundle uses prom-client internally, which is a singleton
        autoregister: false, // prevent registering prom-client because we already do it elsewhere
        promRegistry: metricsClient.getClient().register, // ensure we use the same prom-client registry
    }));
    const router = express.Router();
    (0, router_1.routeApp)(Object.assign(Object.assign({}, args), { router }));
    app.use('/', router);
    return app;
}
//# sourceMappingURL=app.js.map