"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForSuccessOrFailEvents = waitForSuccessOrFailEvents;
exports.waitForSuccessEventsOrFailEvent = waitForSuccessEventsOrFailEvent;
function waitForSuccessOrFailEvents(eventEmitter, successEvent, failEvent) {
    return waitForSuccessEventsOrFailEvent(eventEmitter, [successEvent], failEvent);
}
function waitForSuccessEventsOrFailEvent(eventEmitter, successEvents, failEvent) {
    return new Promise((resolve, reject) => {
        let successListener;
        let failListener;
        successListener = (result) => {
            eventEmitter.removeListener(failEvent, failListener);
            resolve(result);
        };
        failListener = () => {
            successEvents.forEach((se) => eventEmitter.removeListener(se, successListener));
            reject(new Error('error: ' + failEvent));
        };
        successEvents.forEach((se) => eventEmitter.once(se, successListener));
        eventEmitter.once(failEvent, failListener);
    });
}
//# sourceMappingURL=eventsHelpers.js.map