"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeferredState = void 0;
const deferred_1 = require("../../../Promise/deferred");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:AMQP:EventSourcing:Locked:deferredState');
/**
 * DeferredState is a helper class for managing deferred promises for the LockedEventConsumer.
 * It allows to manage internal map of deferred promises for each lock-key.
 */
class DeferredState {
    constructor() {
        this.deferredMap = new Map();
    }
    /**
     * Create a deferred for the current lock-keys and push it to the list for subsequent promises to wait on.
     */
    addDeferred(lockKeys) {
        var _a;
        debug('Adding deferred for lock-keys', { lockKeys });
        const currentDeferred = (0, deferred_1.createDeferred)(true);
        for (const lockKey of lockKeys) {
            const listOfDeferred = (_a = this.deferredMap.get(lockKey)) !== null && _a !== void 0 ? _a : [];
            this.deferredMap.set(lockKey, listOfDeferred);
            listOfDeferred.push(currentDeferred);
        }
        return currentDeferred;
    }
    /**
     * Remove the deferred from the list for the given lock-keys.
     * If the list becomes empty, remove it from the map (cleanup).
     */
    removeDeferred(lockKeys, deferred) {
        var _a;
        debug('Removing deferred for lock-keys', { lockKeys });
        for (const lockKey of lockKeys) {
            const listOfDeferred = (_a = this.deferredMap.get(lockKey)) !== null && _a !== void 0 ? _a : [];
            const index = listOfDeferred.indexOf(deferred);
            if (index !== -1) {
                listOfDeferred.splice(index, 1);
            }
            if (listOfDeferred.length === 0) {
                this.deferredMap.delete(lockKey);
            }
        }
    }
    /**
     * Get a list of promises for all previously created deferred with the same lock-keys.
     */
    getPreviousPromises(lockKeys) {
        var _a;
        const promises = [];
        for (const lockKey of lockKeys) {
            const listOfDeferred = (_a = this.deferredMap.get(lockKey)) !== null && _a !== void 0 ? _a : [];
            for (const deferred of listOfDeferred) {
                promises.push(deferred.promise);
            }
        }
        debug('Getting previous promises for lock-keys', { lockKeys, count: promises.length });
        return promises;
    }
}
exports.DeferredState = DeferredState;
//# sourceMappingURL=deferredState.js.map