"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeoutError = void 0;
exports.rejectAfterTimeout = rejectAfterTimeout;
exports.withTimeout = withTimeout;
var TimeoutError = /** @class */ (function (_super) {
    __extends(TimeoutError, _super);
    function TimeoutError(message) {
        var _this = _super.call(this, message !== null && message !== void 0 ? message : 'Timeout') || this;
        // Set the prototype explicitly because of bug in TypeScript https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(_this, TimeoutError.prototype);
        return _this;
    }
    return TimeoutError;
}(Error));
exports.TimeoutError = TimeoutError;
function rejectAfterTimeout(timeout, errorMessage) {
    return new Promise(function (_resolve, reject) {
        setTimeout(function () { return reject(new TimeoutError(errorMessage)); }, timeout);
    });
}
/**
 * Wraps promise and returns a new promise that will be rejected
 * after timeoutMs if the original promise is not resolved or rejected.
 */
function withTimeout(promise, timeoutMs, errorMessage) {
    return Promise.race([promise, rejectAfterTimeout(timeoutMs, errorMessage)]);
}
//# sourceMappingURL=timeout.js.map