"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertLongWeekdayTimerSettingsToLegacyTimerSettings = convertLongWeekdayTimerSettingsToLegacyTimerSettings;
exports.convertShortWeekdayTimerSettingsToLegacyTimerSettings = convertShortWeekdayTimerSettingsToLegacyTimerSettings;
exports.convertLegacyTimerToShortWeekdayTimer = convertLegacyTimerToShortWeekdayTimer;
exports.convertTimersToLongWeekdayTimerSettings = convertTimersToLongWeekdayTimerSettings;
exports.convertTimersToShortWeekdayTimerSettings = convertTimersToShortWeekdayTimerSettings;
var object_1 = require("../Utils/object");
var convertWeekday_1 = require("./convertWeekday");
function convertLongWeekdayTimerSettingsToLegacyTimerSettings(settings) {
    return (0, object_1.mapObject)(settings, function (_a) {
        var weekdays = _a.weekdays, t = __rest(_a, ["weekdays"]);
        return (__assign(__assign({}, t), convertWeekday_1.convertWeekday.fromLong(weekdays).toLegacy()));
    });
}
function convertShortWeekdayTimerSettingsToLegacyTimerSettings(settings) {
    return (0, object_1.mapObject)(settings, function (_a) {
        var weekdays = _a.weekdays, t = __rest(_a, ["weekdays"]);
        return (__assign(__assign({}, t), convertWeekday_1.convertWeekday.fromShort(weekdays).toLegacy()));
    });
}
function convertLegacyTimerToShortWeekdayTimer(settings) {
    return (0, object_1.mapObject)(settings, function (_a) {
        var sun = _a.sun, mon = _a.mon, tue = _a.tue, wed = _a.wed, thu = _a.thu, fri = _a.fri, sat = _a.sat, t = __rest(_a, ["sun", "mon", "tue", "wed", "thu", "fri", "sat"]);
        return (__assign(__assign({}, t), { weekdays: convertWeekday_1.convertWeekday.fromLegacy({ sun: sun, mon: mon, tue: tue, wed: wed, thu: thu, fri: fri, sat: sat }).toShort() }));
    });
}
function convertTimersToLongWeekdayTimerSettings(shortWeekdayTimer) {
    var timers = {};
    for (var _i = 0, shortWeekdayTimer_1 = shortWeekdayTimer; _i < shortWeekdayTimer_1.length; _i++) {
        var _a = shortWeekdayTimer_1[_i];
        var weekdays = _a.weekdays, t = __rest(_a, ["weekdays"]);
        timers[t.type] = __assign(__assign({}, t), { weekdays: convertWeekday_1.convertWeekday.fromShort(weekdays).toLong() });
    }
    return timers;
}
function convertTimersToShortWeekdayTimerSettings(shortWeekdayTimer) {
    var timers = {};
    for (var _i = 0, shortWeekdayTimer_2 = shortWeekdayTimer; _i < shortWeekdayTimer_2.length; _i++) {
        var timerSetting = shortWeekdayTimer_2[_i];
        timers[timerSetting.type] = {
            type: timerSetting.type,
            timeOn: timerSetting.timeOn,
            timeOff: timerSetting.timeOff,
            weekdays: timerSetting.weekdays,
        };
    }
    return timers;
}
//# sourceMappingURL=converters.js.map