"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHeadersMiddleware = getHeadersMiddleware;
function getDefaultHeaders() {
    return {
        'Cache-Control': 'no-store',
        'X-Frame-Options': 'DENY',
        'X-Content-Type-Options': 'nosniff',
        'Strict-Transport-Security': 'max-age=31536000',
    };
}
function getHeadersMiddleware() {
    return function (_req, res, next) {
        res.set(getDefaultHeaders());
        next();
    };
}
//# sourceMappingURL=headersMiddleware.js.map