"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnexpectedObjectAttribute = void 0;
exports.default = validateKeys;
exports.isKeyValid = isKeyValid;
const getKeys_1 = require("./getKeys");
const Validation_1 = require("./Validation");
function validateKeys(object, validKeys) {
    const keys = (0, getKeys_1.default)(object);
    const validation = (0, Validation_1.createValidation)(undefined);
    keys.forEach((key) => {
        const notValidKey = !validKeys[key];
        if (notValidKey) {
            validation.addError(new UnexpectedObjectAttribute(key));
        }
    });
    return validation.getOutput();
}
function isKeyValid(validKeys, actualKey) {
    return validKeys.includes(actualKey);
}
class UnexpectedObjectAttribute extends Error {
    constructor(attribute) {
        super(`Unexpected object attribute: ${JSON.stringify(attribute)}`);
    }
}
exports.UnexpectedObjectAttribute = UnexpectedObjectAttribute;
