"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createValidation = createValidation;
function createValidation(value, cast = (value) => value) {
    const errors = [];
    return {
        addError(...messages) {
            errors.push(...messages);
        },
        getOutput() {
            return {
                hasErrors() {
                    return errors.length > 0;
                },
                getErrors() {
                    return errors;
                },
                getCast() {
                    if (this.hasErrors()) {
                        const prettyErrors = this.getErrors().join('\n');
                        throw new Error(prettyErrors);
                    }
                    else {
                        return cast(value);
                    }
                },
            };
        },
    };
}
