"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validKeys = void 0;
exports.default = validateAppletPolicy;
const Validation_1 = require("../../Validation/Validation");
const validateKeys_1 = require("../../Validation/validateKeys");
exports.validKeys = {
    appletUid: true,
    appletVersion: true,
    configuration: true,
    startsAt: true,
    endsAt: true,
    finishEvent: true,
    position: true,
};
function validateAppletPolicy(settings) {
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
