"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailTypeSchema = exports.EmailType = void 0;
const zod_1 = require("zod");
/**
 * Types of emails that we can send
 *
 * The meaning of this is to separate the different types of emails but it doesn't imply any specific content.
 * There can be multiple types of content for the same type of email based on the context.
 *
 * For example, we will send a slightly different invite email in these 2 cases:
 *  - user who's email address falls under a SAML domain
 *  - other users
 * Both of these email will still be "invite" email even if their content is different.
 */
var EmailType;
(function (EmailType) {
    EmailType["Alert"] = "alert";
    EmailType["DeviceAlert"] = "device_alert";
    EmailType["Intro"] = "introduction";
    EmailType["Invite"] = "invite";
    EmailType["PasswordReset"] = "password_reset";
    EmailType["Welcome"] = "welcome";
    EmailType["LicenseCreditsBalanceHasChanged"] = "license_credits_balance_has_changed";
    EmailType["LicenseCreditsBalanceIsLow"] = "license_credits_balance_is_low";
    EmailType["Unknown"] = "";
})(EmailType || (exports.EmailType = EmailType = {}));
exports.EmailTypeSchema = zod_1.z.nativeEnum(EmailType);
