import { z } from 'zod';
export declare const TagUidsArray: z.ZodArray<z.ZodString, "many">;
export declare const DeviceFilterSchema: z.ZodObject<z.objectUtil.extendShape<{
    /** @deprecated use identityHashes property instead */
    identityHash: z.ZodOptional<z.ZodString>;
    identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    accountId: z.ZodOptional<z.ZodNumber>;
    organizationUid: z.ZodOptional<z.ZodString>;
    /** @deprecated use applicationTypes property instead */
    applicationType: z.ZodOptional<z.ZodString>;
    applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    firmwareVersion: z.ZodOptional<z.ZodString>;
    firmwareType: z.ZodOptional<z.ZodString>;
    search: z.ZodOptional<z.ZodString>;
    serialNumber: z.ZodOptional<z.ZodString>;
    /** @deprecated use deviceConfigurationModel entity instead */
    bannedSince: z.ZodOptional<z.ZodDate>;
    policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    createdSince: z.ZodOptional<z.ZodDate>;
    createdUntil: z.ZodOptional<z.ZodDate>;
    filterModelName: z.ZodOptional<z.ZodString>;
    appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    activeAppletVersion: z.ZodOptional<z.ZodString>;
    osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    /** This filter is performed as a logical OR operation of respective fields */
    orFilter: z.ZodOptional<z.ZodObject<{
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        /**
         * Each array inside array should represent group of tag and its children.
         * This argument allows to include all devices that have at least one tag from each family tree.
         */
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strict", z.ZodTypeAny, {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    }, {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    }>>;
    hasPolicy: z.ZodOptional<z.ZodBoolean>;
}, {
    tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    /**
     * Each array inside array should represent group of tag and its children.
     * This argument allows to include all devices that have at least one tag from each family tree.
     */
    tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
    locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}>, "strict", z.ZodTypeAny, {
    search?: string | undefined;
    organizationUid?: string | undefined;
    firmwareVersion?: string | undefined;
    applicationType?: string | undefined;
    tagUids?: string[] | undefined;
    tagWithChildrenUidGroups?: string[][] | undefined;
    locationUids?: string[] | undefined;
    identityHash?: string | undefined;
    identityHashes?: string[] | undefined;
    identityHashesExclude?: string[] | undefined;
    uids?: string[] | undefined;
    uidsExclude?: string[] | undefined;
    accountId?: number | undefined;
    applicationTypes?: string[] | undefined;
    applicationTypeNotEqual?: string | undefined;
    model?: string | undefined;
    brands?: string[] | undefined;
    firmwareType?: string | undefined;
    serialNumber?: string | undefined;
    bannedSince?: Date | undefined;
    policyUids?: string[] | undefined;
    createdSince?: Date | undefined;
    createdUntil?: Date | undefined;
    filterModelName?: string | undefined;
    appletUids?: string[] | undefined;
    activeAppletVersion?: string | undefined;
    osVersions?: string[] | undefined;
    orFilter?: {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    } | undefined;
    hasPolicy?: boolean | undefined;
}, {
    search?: string | undefined;
    organizationUid?: string | undefined;
    firmwareVersion?: string | undefined;
    applicationType?: string | undefined;
    tagUids?: string[] | undefined;
    tagWithChildrenUidGroups?: string[][] | undefined;
    locationUids?: string[] | undefined;
    identityHash?: string | undefined;
    identityHashes?: string[] | undefined;
    identityHashesExclude?: string[] | undefined;
    uids?: string[] | undefined;
    uidsExclude?: string[] | undefined;
    accountId?: number | undefined;
    applicationTypes?: string[] | undefined;
    applicationTypeNotEqual?: string | undefined;
    model?: string | undefined;
    brands?: string[] | undefined;
    firmwareType?: string | undefined;
    serialNumber?: string | undefined;
    bannedSince?: Date | undefined;
    policyUids?: string[] | undefined;
    createdSince?: Date | undefined;
    createdUntil?: Date | undefined;
    filterModelName?: string | undefined;
    appletUids?: string[] | undefined;
    activeAppletVersion?: string | undefined;
    osVersions?: string[] | undefined;
    orFilter?: {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    } | undefined;
    hasPolicy?: boolean | undefined;
}>;
export type DeviceFilter = z.infer<typeof DeviceFilterSchema>;
