"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidWifiStrengthSettings = exports.validKeys = void 0;
exports.default = validateWifiStrengthSettings;
const validateKeys_1 = require("../../../Validation/validateKeys");
const Validation_1 = require("../../../Validation/Validation");
exports.validKeys = {
    strength: true,
};
function validateWifiStrengthSettings(settings) {
    var _a;
    const { strength } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notStrengthValid = !(typeof strength === 'number');
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notStrengthValid) {
        validation.addError(new InvalidWifiStrengthSettings(strength));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidWifiStrengthSettings extends Error {
    constructor(value) {
        super(`Wifi Strength Settings is not valid: ${value}`);
    }
}
exports.InvalidWifiStrengthSettings = InvalidWifiStrengthSettings;
