"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidRemoteControlSettingsEnabled = exports.validKeys = void 0;
exports.default = validateRemoteControlSettings;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    enabled: true,
};
function validateRemoteControlSettings(settings) {
    var _a;
    const { enabled } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notEnabledValid = !(typeof enabled === 'boolean');
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notEnabledValid) {
        validation.addError(new InvalidRemoteControlSettingsEnabled(enabled));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidRemoteControlSettingsEnabled extends Error {
    constructor(enabled) {
        super(`Remote Control Settings Enabled is not boolean: ${enabled}`);
    }
}
exports.InvalidRemoteControlSettingsEnabled = InvalidRemoteControlSettingsEnabled;
