"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidNtpServer = exports.InvalidTimezone = exports.validKeys = void 0;
exports.default = validateDateTimeSettings;
const luxon_1 = require("luxon");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    ntpServer: true,
    timezone: true,
};
function validateDateTimeSettings(settings) {
    var _a;
    const { timezone, ntpServer } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidTimezone = !(timezone === null || (typeof timezone === 'string' && luxon_1.IANAZone.isValidZone(timezone)));
    const notValidNtpServer = !(timezone === null || (typeof ntpServer === 'string' && ntpServer.length > 1));
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidTimezone) {
        validation.addError(new InvalidTimezone(timezone));
    }
    if (notValidNtpServer) {
        validation.addError(new InvalidNtpServer(ntpServer));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidTimezone extends Error {
    constructor(timezone) {
        super(`DateTime Setting Timezone is not in IANA format: ${timezone}`);
    }
}
exports.InvalidTimezone = InvalidTimezone;
class InvalidNtpServer extends Error {
    constructor(ntpServer) {
        super(`DateTime Settings NtpServer is not valid: ${ntpServer}`);
    }
}
exports.InvalidNtpServer = InvalidNtpServer;
