import { z } from 'zod';
export declare const AndroidDevicePackageInstallationSchema: z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /**
     * Proprietary package name (platform independent)
     */
    packageName: z.ZodString;
    /**
     * organization uid which is a part of URL to download package
     */
    ownerOrganizationUid: z.ZodString;
    /**
     * Contains unique hash (usually checksum of package file) which is unique for every build
     * E.g.:
     * Android - apk file sha256 (equal to specs.apkSha256)
     * TODO other platforms
     */
    buildHash: z.ZodString;
    /**
     * Human readable version name
     * It's usually uniq for package real version but usually it's same for different builds (architectures)
     */
    version: z.ZodString;
    /**
     * Additional postfix of version to recognize different builds
     * Used for back compatibility in old android packages
     */
    build: z.ZodNullable<z.ZodString>;
    /**
     * Platform specific information differs for each application type
     */
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodObject<{
        packageName: z.ZodString;
        sdkVersion: z.ZodNumber;
        supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
        multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
        versionCode: z.ZodOptional<z.ZodNumber>;
        targetSdkVersion: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }>;
}>, "strict", z.ZodTypeAny, {
    version: string;
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}, {
    version: string;
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}>;
export type AndroidDevicePackageInstallation = z.infer<typeof AndroidDevicePackageInstallationSchema>;
export declare const DevicePackageInstallationSchema: z.ZodObject<z.objectUtil.extendShape<{
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    /**
     * Proprietary package name (platform independent)
     */
    packageName: z.ZodString;
    /**
     * organization uid which is a part of URL to download package
     */
    ownerOrganizationUid: z.ZodString;
    /**
     * Contains unique hash (usually checksum of package file) which is unique for every build
     * E.g.:
     * Android - apk file sha256 (equal to specs.apkSha256)
     * TODO other platforms
     */
    buildHash: z.ZodString;
    /**
     * Human readable version name
     * It's usually uniq for package real version but usually it's same for different builds (architectures)
     */
    version: z.ZodString;
    /**
     * Additional postfix of version to recognize different builds
     * Used for back compatibility in old android packages
     */
    build: z.ZodNullable<z.ZodString>;
    /**
     * Platform specific information differs for each application type
     */
    specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
}, {
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodObject<{
        packageName: z.ZodString;
        sdkVersion: z.ZodNumber;
        supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
        multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
        versionCode: z.ZodOptional<z.ZodNumber>;
        targetSdkVersion: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }>;
}>, "strict", z.ZodTypeAny, {
    version: string;
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}, {
    version: string;
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}>;
export type DevicePackageInstallation = z.infer<typeof DevicePackageInstallationSchema>;
