"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppletVersionConfigDefinitionSchema = exports.EncryptedSchema = exports.UnknownSchema = exports.SecretSchema = exports.NumberSchema = exports.EnumSchema = exports.UrlSchema = exports.StringSchema = exports.BaseDataSchema = exports.ValueType = void 0;
const zod_1 = require("zod");
var ValueType;
(function (ValueType) {
    ValueType["String"] = "string";
    ValueType["Url"] = "url";
    ValueType["Enum"] = "enum";
    ValueType["Number"] = "number";
    ValueType["Secret"] = "secret";
    ValueType["Unknown"] = "unknown";
    ValueType["Encrypted"] = "encrypted";
})(ValueType || (exports.ValueType = ValueType = {}));
exports.BaseDataSchema = zod_1.z.object({
    name: zod_1.z.string(),
    description: zod_1.z.string().optional(),
    mandatory: zod_1.z.boolean().optional(),
    placeholder: zod_1.z.string().optional(),
});
exports.StringSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.String),
    maxLength: zod_1.z.number().optional(),
});
exports.UrlSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.Url),
});
exports.EnumSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.Enum),
    list: zod_1.z.array(zod_1.z.union([zod_1.z.string(), zod_1.z.number()])).optional(),
});
exports.NumberSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.Number),
    min: zod_1.z.number().optional(),
    max: zod_1.z.number().optional(),
});
exports.SecretSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.Secret),
});
exports.UnknownSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.Unknown),
});
exports.EncryptedSchema = exports.BaseDataSchema.extend({
    valueType: zod_1.z.literal(ValueType.Encrypted),
});
exports.AppletVersionConfigDefinitionSchema = zod_1.z.discriminatedUnion('valueType', [
    exports.StringSchema,
    exports.UrlSchema,
    exports.EnumSchema,
    exports.NumberSchema,
    exports.SecretSchema,
    exports.UnknownSchema,
    exports.EncryptedSchema,
]);
