"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidConditionInAnyAndAllContainsCommonValues = exports.InvalidConditionInputFormat = void 0;
exports.default = areAlertConditionsValid;
const Validation_1 = require("../../Validation/Validation");
const validateConditions_1 = require("./validateConditions");
const validateAlertType_1 = require("./validateAlertType");
function areAlertConditionsValid(conditions, alertType) {
    var _a;
    const validation = (0, Validation_1.createValidation)({});
    const isValidInput = typeof conditions === 'object' && !(0, validateAlertType_1.default)(alertType).hasErrors();
    if (isValidInput) {
        const validAlertType = alertType;
        const conditionsObj = (_a = conditions) !== null && _a !== void 0 ? _a : {};
        const conditionFromAll = conditionsObj.ALL.length > 0 ? conditionsObj.ALL.map((elements) => elements.type) : [];
        const conditionFromAny = conditionsObj.AND_ANY_OF.length > 0 ? conditionsObj.AND_ANY_OF.map((elements) => elements.type) : [];
        const isReadyForValidation = conditionFromAll.length > 1 && conditionFromAny.length > 1;
        const hasUniqueTypesAll = Array.from(new Set(conditionFromAll)).length === conditionFromAll.length;
        const hasUniqueTypesAny = Array.from(new Set(conditionFromAny)).length === conditionFromAny.length;
        if (!isReadyForValidation && !conditionFromAny.some((c) => conditionFromAll.includes(c)) && hasUniqueTypesAll && hasUniqueTypesAny) {
            const validateAll = (0, validateConditions_1.default)(conditionsObj.ALL, validAlertType);
            if (validateAll.hasErrors()) {
                validation.addError(...validateAll.getErrors());
            }
            const validateAnyOf = (0, validateConditions_1.default)(conditionsObj.AND_ANY_OF, validAlertType);
            if (validateAnyOf.hasErrors()) {
                validation.addError(...validateAnyOf.getErrors());
            }
        }
        else {
            validation.addError(new InvalidConditionInAnyAndAllContainsCommonValues(conditionsObj.ALL, conditionsObj.AND_ANY_OF));
        }
    }
    else {
        validation.addError(new InvalidConditionInputFormat(conditions));
    }
    return validation.getOutput();
}
class InvalidConditionInputFormat extends Error {
    constructor(condition) {
        super(`Condition input format is not valid ${JSON.stringify(condition)}`);
    }
}
exports.InvalidConditionInputFormat = InvalidConditionInputFormat;
class InvalidConditionInAnyAndAllContainsCommonValues extends Error {
    constructor(all, andAnyOf) {
        super(`Condition from ALL and AND_ANY_OF contain common elements ALL:${JSON.stringify(all)}, AND_ANY_OF: ${JSON.stringify(andAnyOf)}`);
    }
}
exports.InvalidConditionInAnyAndAllContainsCommonValues = InvalidConditionInAnyAndAllContainsCommonValues;
